/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.client;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import kg.apc.perfmon.client.NIOTransport;
import kg.apc.perfmon.client.StreamTransport;
import kg.apc.perfmon.client.Transport;
import kg.apc.perfmon.client.UDPInputStream;
import kg.apc.perfmon.client.UDPOutputStream;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TransportFactory {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public static Transport getTransport(SocketAddress addr) throws IOException {
        try {
            log.debug("Connecting TCP");
            Transport trans = TransportFactory.TCPInstance(addr);
            if (!trans.test()) {
                throw new IOException("Agent is unreachable via TCP");
            }
            return trans;
        }
        catch (IOException e) {
            log.info("Can't connect TCP transport for host: " + addr.toString(), (Throwable)e);
            try {
                log.debug("Connecting UDP");
                Transport trans = TransportFactory.UDPInstance(addr);
                if (!trans.test()) {
                    throw new IOException("Agent is unreachable via UDP");
                }
                return trans;
            }
            catch (IOException ex) {
                log.info("Can't connect UDP transport for host: " + addr.toString(), (Throwable)ex);
                throw ex;
            }
        }
    }

    public static Transport NIOUDPInstance(SocketAddress addr) throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        channel.connect(addr);
        NIOTransport ret = new NIOTransport();
        ret.setChannels(channel, channel);
        return ret;
    }

    public static Transport NIOTCPInstance(SocketAddress addr) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.connect(addr);
        NIOTransport ret = new NIOTransport();
        ret.setChannels(channel, channel);
        return ret;
    }

    public static Transport TCPInstance(SocketAddress addr) throws IOException {
        Socket sock = new Socket();
        sock.setSoTimeout(TransportFactory.getTimeout());
        sock.connect(addr);
        StreamTransport trans = new StreamTransport();
        trans.setStreams(sock.getInputStream(), sock.getOutputStream());
        trans.setAddressLabel(addr.toString());
        return trans;
    }

    private static int getTimeout() {
        return 500;
    }

    public static Transport UDPInstance(SocketAddress addr) throws IOException {
        DatagramSocket sock = new DatagramSocket();
        sock.setSoTimeout(TransportFactory.getTimeout());
        sock.connect(addr);
        StreamTransport trans = new StreamTransport();
        trans.setStreams(new UDPInputStream(sock), new UDPOutputStream(sock));
        trans.setAddressLabel(addr.toString());
        return trans;
    }
}

