/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.metrics;

import java.util.Hashtable;
import kg.apc.perfmon.metrics.AbstractCPUMetric;
import kg.apc.perfmon.metrics.AbstractMemMetric;
import kg.apc.perfmon.metrics.DiskIOMetric;
import kg.apc.perfmon.metrics.ExecMetric;
import kg.apc.perfmon.metrics.InvalidPerfMonMetric;
import kg.apc.perfmon.metrics.JMXMetric;
import kg.apc.perfmon.metrics.MetricParamsSigar;
import kg.apc.perfmon.metrics.NetworkIOMetric;
import kg.apc.perfmon.metrics.SwapMetric;
import kg.apc.perfmon.metrics.TCPStatMetric;
import kg.apc.perfmon.metrics.TailMetric;
import kg.apc.perfmon.metrics.jmx.JMXConnectorHelper;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.hyperic.sigar.SigarProxy;

public abstract class AbstractPerfMonMetric {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected static final String PARAMS_DELIMITER = ":";
    protected final SigarProxy sigarProxy;
    private static final Hashtable unitDividingFactors = new Hashtable();

    public AbstractPerfMonMetric(SigarProxy aSigar) {
        this.sigarProxy = aSigar;
        unitDividingFactors.put("b", new Integer(1));
        unitDividingFactors.put("kb", new Integer(1024));
        unitDividingFactors.put("mb", new Integer(0x100000));
    }

    protected int getUnitDividingFactor(String unit) {
        if (!unitDividingFactors.containsKey(unit)) {
            return 1;
        }
        return (Integer)unitDividingFactors.get(unit);
    }

    public abstract void getValue(StringBuffer var1) throws Exception;

    public static AbstractPerfMonMetric createMetric(String metricType, String metricParamsStr, SigarProxy sigarProxy) {
        AbstractPerfMonMetric metric;
        block13: {
            log.debug("Creating metric: " + metricType + " with params: " + metricParamsStr);
            if (metricType.indexOf(32) > 0) {
                metricType = metricType.substring(0, metricType.indexOf(32));
            }
            MetricParamsSigar metricParams = MetricParamsSigar.createFromString(metricParamsStr, sigarProxy);
            try {
                if (metricType.equalsIgnoreCase("exec")) {
                    metric = new ExecMetric(metricParams);
                    break block13;
                }
                if (metricType.equalsIgnoreCase("tail")) {
                    metric = new TailMetric(metricParams);
                    break block13;
                }
                if (metricType.equalsIgnoreCase("cpu")) {
                    metric = AbstractCPUMetric.getMetric(sigarProxy, metricParams);
                    break block13;
                }
                if (metricType.equalsIgnoreCase("memory")) {
                    metric = AbstractMemMetric.getMetric(sigarProxy, metricParams);
                    break block13;
                }
                if (metricType.equalsIgnoreCase("swap")) {
                    metric = new SwapMetric(sigarProxy, metricParams);
                    break block13;
                }
                if (metricType.equalsIgnoreCase("disks")) {
                    metric = new DiskIOMetric(sigarProxy, metricParams);
                    break block13;
                }
                if (metricType.equalsIgnoreCase("network")) {
                    metric = new NetworkIOMetric(sigarProxy, metricParams);
                    break block13;
                }
                if (metricType.equalsIgnoreCase("tcp")) {
                    metric = new TCPStatMetric(sigarProxy, metricParams);
                    break block13;
                }
                if (metricType.equalsIgnoreCase("jmx")) {
                    metric = new JMXMetric(metricParams, new JMXConnectorHelper());
                    break block13;
                }
                throw new RuntimeException("No collector object for metric type " + metricType);
            }
            catch (IllegalArgumentException ex) {
                log.error(ex.toString());
                log.error("Invalid parameters specified for metric " + metricType + ": " + metricParams);
                metric = new InvalidPerfMonMetric();
            }
            catch (RuntimeException ex) {
                log.error("Invalid metric specified: " + metricType, (Throwable)ex);
                metric = new InvalidPerfMonMetric();
            }
        }
        log.debug("Have metric object: " + metric.toString());
        return metric;
    }
}

