/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.xmpp;

import com.blazemeter.jmeter.xmpp.JMeterXMPPConnectionBase;
import com.blazemeter.jmeter.xmpp.Loggers;
import com.blazemeter.jmeter.xmpp.actions.AbstractXMPPAction;
import com.blazemeter.jmeter.xmpp.actions.Connect;
import com.blazemeter.jmeter.xmpp.actions.Disconnect;
import com.blazemeter.jmeter.xmpp.actions.Login;
import com.blazemeter.jmeter.xmpp.actions.NoOp;
import com.blazemeter.jmeter.xmpp.actions.RawXML;
import com.blazemeter.jmeter.xmpp.actions.RosterAction;
import com.blazemeter.jmeter.xmpp.actions.SendMessage;
import com.blazemeter.jmeter.xmpp.actions.SendPresence;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.bosh.BOSHConfiguration;
import org.jivesoftware.smack.bosh.XMPPBOSHConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;

public class JMeterXMPPConnection
extends JMeterXMPPConnectionBase {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final BlockingQueue<XMPPConnection> connectionRegistry = new LinkedBlockingQueue<XMPPConnection>();
    private XMPPConnection conn;
    private Map<String, AbstractXMPPAction> actions = JMeterXMPPConnection.getAvailableActions();

    public void testEnded(String host) {
        log.debug("Test ended: " + host);
        for (XMPPConnection conn : connectionRegistry) {
            connectionRegistry.remove(conn);
            if (!conn.isConnected()) continue;
            try {
                log.debug("Disconnecting: " + conn.getConnectionID());
                conn.disconnect();
            }
            catch (SmackException.NotConnectedException e) {
                log.error("Not connected, nothing to disconnect");
            }
        }
    }

    public XMPPConnection getConnection() throws NoSuchAlgorithmException, KeyManagementException, SmackException, InterruptedException {
        if (this.conn == null) {
            XMPPTCPConnection newConn;
            String address = this.getAddress();
            String serv_name = this.getServiceName();
            if (serv_name.isEmpty()) {
                serv_name = address;
            }
            int port = Integer.parseInt(this.getPort());
            log.debug("Creating connection: " + address + ":" + port + "/" + serv_name);
            if (JMeterXMPPConnectionBase.Type.valueOf(this.getConnectionType()) == JMeterXMPPConnectionBase.Type.BOSH) {
                BOSHConfiguration conf = new BOSHConfiguration(this.isBOSHSSL(), address, port, this.getBOSHURL(), serv_name);
                conf.setCustomSSLContext(this.getSSLContext());
                conf.setRosterLoadedAtLogin(true);
                conf.setSendPresence(false);
                newConn = new XMPPBOSHConnection(conf);
            } else {
                ConnectionConfiguration conf = new ConnectionConfiguration(address, port, serv_name);
                conf.setRosterLoadedAtLogin(true);
                conf.setSendPresence(false);
                conf.setCustomSSLContext(this.getSSLContext());
                newConn = new XMPPTCPConnection(conf);
            }
            connectionRegistry.put((XMPPConnection)newConn);
            this.setUpConnection((XMPPConnection)newConn);
        }
        return this.conn;
    }

    private void setUpConnection(XMPPConnection newConn) {
        this.conn = newConn;
        this.conn.setPacketReplyTimeout((long)Integer.parseInt(this.getPacketReplyTimeout()));
        this.conn.setFromMode(this.getFromMode());
        if (log.isDebugEnabled()) {
            this.conn.addConnectionListener((ConnectionListener)new Loggers.LogConn(this.conn));
            this.conn.addPacketListener((PacketListener)new Loggers.LogRecv(this.conn), (PacketFilter)new AndFilter());
            this.conn.addPacketSendingListener((PacketListener)new Loggers.LogSent(this.conn), (PacketFilter)new AndFilter());
        }
        for (AbstractXMPPAction action : this.actions.values()) {
            if (action instanceof PacketListener) {
                this.conn.addPacketListener((PacketListener)action, action.getPacketFilter());
            }
            if (!(action instanceof ConnectionListener)) continue;
            this.conn.addConnectionListener((ConnectionListener)action);
        }
    }

    public static Map<String, AbstractXMPPAction> getAvailableActions() {
        TreeMap<String, AbstractXMPPAction> actions = new TreeMap<String, AbstractXMPPAction>(new OrderComparator());
        try {
            for (String cls : JMeterUtils.findClassesThatExtend(AbstractXMPPAction.class)) {
                actions.put(cls, (AbstractXMPPAction)Class.forName(cls).newInstance());
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error("Error loading actions", (Throwable)e);
        }
        return actions;
    }

    public Map<String, AbstractXMPPAction> getActions() {
        return this.actions;
    }

    @Override
    public void resetConnection() {
        connectionRegistry.remove(this.conn);
        this.conn = null;
    }

    private static class OrderComparator
    implements Comparator<String>,
    Serializable {
        private static final List<String> fixed = Arrays.asList(Connect.class.getCanonicalName(), Login.class.getCanonicalName(), RosterAction.class.getCanonicalName(), SendPresence.class.getCanonicalName(), SendMessage.class.getCanonicalName(), RawXML.class.getCanonicalName(), NoOp.class.getCanonicalName(), Disconnect.class.getCanonicalName());

        private OrderComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1.equals(s2)) {
                return 0;
            }
            int i1 = fixed.indexOf(s1);
            int i2 = fixed.indexOf(s2);
            if (i1 < 0 && i2 < 0) {
                return s1.compareTo(s2);
            }
            if (i1 < 0) {
                return 1;
            }
            if (i2 < 0) {
                return -1;
            }
            return i1 > i2 ? 1 : -1;
        }
    }
}

