/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.xmpp;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jivesoftware.smack.XMPPConnection;

public abstract class JMeterXMPPConnectionBase
extends ConfigTestElement
implements TestStateListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String ADDRESS = "address";
    private static final String PORT = "port";
    private static final String SERVICE_NAME = "service_name";
    private static final String TIMEOUT = "timeout";
    private static final String TYPE = "class";
    private static final String BOSH_IS_SSL = "bosh_is_ssl";
    private static final String BOSH_URL = "bosh_url";
    private static final String FROM_MODE = "from_mode";

    public String getAddress() {
        return this.getPropertyAsString(ADDRESS);
    }

    public void setAddress(String value) {
        this.setProperty(ADDRESS, value);
    }

    public String getPort() {
        return this.getPropertyAsString(PORT, "5222");
    }

    public void setPort(String value) {
        this.setProperty(PORT, value);
    }

    public String getServiceName() {
        return this.getPropertyAsString(SERVICE_NAME);
    }

    public void setServiceName(String value) {
        this.setProperty(SERVICE_NAME, value);
    }

    public boolean isBOSHSSL() {
        return this.getPropertyAsBoolean(BOSH_IS_SSL);
    }

    public void setBOSHSSL(boolean value) {
        this.setProperty(BOSH_IS_SSL, value);
    }

    public String getBOSHURL() {
        return this.getPropertyAsString(BOSH_URL, "/http-bind/");
    }

    public void setBOSHURL(String value) {
        this.setProperty(BOSH_URL, value);
    }

    public String getPacketReplyTimeout() {
        return this.getPropertyAsString(TIMEOUT, "1000");
    }

    public void setPacketReplyTimeout(String value) {
        this.setProperty(TIMEOUT, value);
    }

    public String getConnectionType() {
        return this.getPropertyAsString(TYPE, Type.TCP.toString());
    }

    public void setConnectionType(String value) {
        this.setProperty(TYPE, value);
    }

    public XMPPConnection.FromMode getFromMode() {
        String str = this.getPropertyAsString(FROM_MODE, XMPPConnection.FromMode.USER.toString());
        if (str.equals(XMPPConnection.FromMode.USER.toString())) {
            return XMPPConnection.FromMode.USER;
        }
        if (str.equals(XMPPConnection.FromMode.UNCHANGED.toString())) {
            return XMPPConnection.FromMode.UNCHANGED;
        }
        if (str.equals(XMPPConnection.FromMode.OMITTED.toString())) {
            return XMPPConnection.FromMode.OMITTED;
        }
        throw new IllegalArgumentException("Unhandled value for fromMode: " + str);
    }

    public void setFromMode(String value) {
        this.setProperty(FROM_MODE, value);
    }

    public void testStarted(String host) {
    }

    protected SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(this.getKS(), this.getTM(), new SecureRandom());
        return ctx;
    }

    private KeyManager[] getKS() {
        return new KeyManager[0];
    }

    private TrustManager[] getTM() {
        TrustManager[] res = new TrustManager[]{new DummyTrustManager()};
        return res;
    }

    public void testEnded() {
        this.testEnded("");
    }

    public void testStarted() {
        this.testStarted("");
    }

    public abstract void resetConnection();

    private class DummyTrustManager
    implements X509TrustManager {
        private DummyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            log.debug("checkClientTrusted " + s + ": " + Arrays.toString(x509Certificates));
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            log.debug("checkServerTrusted " + s);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            log.debug("getAcceptedIssuers");
            return new X509Certificate[0];
        }
    }

    public static enum Type {
        TCP,
        BOSH;

    }
}

