/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.xmpp;

import com.blazemeter.jmeter.xmpp.JMeterXMPPConnection;
import com.blazemeter.jmeter.xmpp.JMeterXMPPConnectionBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jivesoftware.smack.XMPPConnection;

public class JMeterXMPPConnectionGui
extends AbstractConfigGui {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private JTextField address;
    private JTextField port;
    private JTextField serviceName;
    private JTextField timeout;
    private JComboBox<JMeterXMPPConnectionBase.Type> connectionClass;
    private JComboBox<XMPPConnection.FromMode> fromMode;

    public JMeterXMPPConnectionGui() {
        this.init();
        this.initFields();
    }

    private void initFields() {
        this.address.setText("localhost");
        this.port.setText("5222");
        this.serviceName.setText("localhost");
        this.timeout.setText("1000");
        this.connectionClass.setSelectedItem((Object)JMeterXMPPConnectionBase.Type.TCP);
        this.fromMode.setSelectedItem(XMPPConnection.FromMode.USER);
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)this.makeTitlePanel(), (String)this.getWikiPage()), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("Server Address: ", 4));
        this.address = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.address);
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("Port: ", 4));
        this.port = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.port);
        this.addToPanel(mainPanel, labelConstraints, 0, 2, new JLabel("Service Name: ", 4));
        this.serviceName = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 2, this.serviceName);
        this.addToPanel(mainPanel, labelConstraints, 0, 3, new JLabel("Timeout, ms: ", 4));
        this.timeout = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 3, this.timeout);
        this.addToPanel(mainPanel, labelConstraints, 0, 4, new JLabel("Transport: ", 4));
        this.connectionClass = new JComboBox();
        this.addToPanel(mainPanel, editConstraints, 1, 4, this.connectionClass);
        this.connectionClass.addItem(JMeterXMPPConnectionBase.Type.TCP);
        this.connectionClass.addItem(JMeterXMPPConnectionBase.Type.BOSH);
        this.addToPanel(mainPanel, labelConstraints, 0, 5, new JLabel("Value for 'from' attribute: ", 4));
        this.fromMode = new JComboBox();
        this.addToPanel(mainPanel, editConstraints, 1, 5, this.fromMode);
        this.fromMode.addItem(XMPPConnection.FromMode.USER);
        this.fromMode.addItem(XMPPConnection.FromMode.UNCHANGED);
        this.fromMode.addItem(XMPPConnection.FromMode.OMITTED);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private String getWikiPage() {
        return "XMPPConnection";
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    public void clearGui() {
        super.clearGui();
        this.initFields();
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public String getStaticLabel() {
        return "bzm - XMPP Connection";
    }

    public TestElement createTestElement() {
        JMeterXMPPConnection el = new JMeterXMPPConnection();
        this.modifyTestElement((TestElement)el);
        el.setComment("This plugin was developed by www.blazemeter.com");
        return el;
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof JMeterXMPPConnection) {
            JMeterXMPPConnection conn = (JMeterXMPPConnection)element;
            this.address.setText(conn.getAddress());
            this.port.setText(conn.getPort());
            this.serviceName.setText(conn.getServiceName());
            this.timeout.setText(conn.getPacketReplyTimeout());
            this.connectionClass.setSelectedItem(conn.getConnectionType());
            this.fromMode.setSelectedItem(conn.getFromMode());
        }
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        if (element instanceof JMeterXMPPConnection) {
            JMeterXMPPConnection conn = (JMeterXMPPConnection)element;
            conn.setAddress(this.address.getText());
            conn.setPort(this.port.getText());
            conn.setServiceName(this.serviceName.getText());
            conn.setPacketReplyTimeout(this.timeout.getText());
            conn.setConnectionType(this.connectionClass.getSelectedItem().toString());
            conn.setFromMode(this.fromMode.getSelectedItem().toString());
        }
    }
}

