/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.xmpp;

import com.blazemeter.jmeter.xmpp.JMeterXMPPConnection;
import com.blazemeter.jmeter.xmpp.JMeterXMPPSampler;
import com.blazemeter.jmeter.xmpp.actions.AbstractXMPPAction;
import com.blazemeter.ui.ComponentTitledBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JMeterXMPPSamplerGui
extends AbstractSamplerGui
implements ActionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String CONTAINER = "container";
    private ButtonGroup actionsGroup;
    private Map<String, AbstractXMPPAction> actions = this.getActions();

    protected Map<String, AbstractXMPPAction> getActions() {
        return JMeterXMPPConnection.getAvailableActions();
    }

    public JMeterXMPPSamplerGui() {
        this.init();
        this.initFields();
    }

    public TestElement createTestElement() {
        JMeterXMPPSampler el = new JMeterXMPPSampler();
        this.modifyTestElement((TestElement)el);
        el.setComment("This plugin is developed by www.blazemeter.com");
        return el;
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof JMeterXMPPSampler) {
            JMeterXMPPSampler sampler = (JMeterXMPPSampler)element;
            this.selectActionByName(sampler.getAction());
            for (AbstractXMPPAction action : this.actions.values()) {
                action.setGuiFieldsFromSampler(sampler);
            }
        }
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        if (element instanceof JMeterXMPPSampler) {
            JMeterXMPPSampler sampler = (JMeterXMPPSampler)element;
            sampler.setAction(this.getSelectedAction());
            for (AbstractXMPPAction action : this.actions.values()) {
                action.setSamplerProperties(sampler);
            }
        }
    }

    public void clearGui() {
        super.clearGui();
        this.initFields();
    }

    public String getLabelResource() {
        return this.getClass().getCanonicalName();
    }

    public String getStaticLabel() {
        return "bzm - XMPP Sampler";
    }

    private void initFields() {
        for (AbstractXMPPAction action : this.actions.values()) {
            action.clearGui();
        }
        if (this.actionsGroup.getButtonCount() > 0) {
            this.actionsGroup.getElements().nextElement().doClick();
        }
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)this.makeTitlePanel(), (String)this.getWikiPage()), "North");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.addActionBlocks(mainPanel);
        this.add(mainPanel, "Center");
    }

    private void addActionBlocks(JPanel mainPanel) {
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.actionsGroup = new ButtonGroup();
        for (AbstractXMPPAction action : this.actions.values()) {
            JRadioButton radio = new JRadioButton(action.getLabel());
            radio.addActionListener(this);
            this.actionsGroup.add(radio);
            JPanel contentPanel = new JPanel(new GridBagLayout());
            radio.putClientProperty(CONTAINER, contentPanel);
            action.addUI(contentPanel, labelConstraints, editConstraints);
            ComponentTitledBorder border = new ComponentTitledBorder(radio, contentPanel, BorderFactory.createEtchedBorder());
            contentPanel.setBorder(border);
            contentPanel.setEnabled(false);
            mainPanel.add(contentPanel);
            mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        }
    }

    private void selectActionByName(String action) {
        AbstractXMPPAction actionObj = this.actions.get(action);
        Enumeration<AbstractButton> buttons = this.actionsGroup.getElements();
        if (actionObj != null) {
            while (buttons.hasMoreElements()) {
                AbstractButton button = buttons.nextElement();
                if (!button.getText().equals(actionObj.getLabel())) continue;
                button.doClick();
                return;
            }
        }
        log.warn("Did not find control to select for action: " + action);
    }

    private String getSelectedAction() {
        Enumeration<AbstractButton> buttons = this.actionsGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.isSelected()) continue;
            for (AbstractXMPPAction action : this.actions.values()) {
                if (!action.getLabel().equals(button.getText())) continue;
                return action.getClass().getCanonicalName();
            }
        }
        log.warn("No action selected");
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JRadioButton button = (JRadioButton)actionEvent.getSource();
        this.disableAllBlocks();
        this.setBlockEnabled(button, true);
        if (button.getParent() != null && button.getParent().getParent() != null) {
            button.getParent().getParent().getParent().repaint();
        }
    }

    private void disableAllBlocks() {
        Enumeration<AbstractButton> btns = this.actionsGroup.getElements();
        while (btns.hasMoreElements()) {
            AbstractButton btn = btns.nextElement();
            this.setBlockEnabled(btn, false);
        }
    }

    private void setBlockEnabled(AbstractButton obj, boolean b) {
        Container container = (Container)obj.getClientProperty(CONTAINER);
        for (Component component : container.getComponents()) {
            component.setEnabled(b);
        }
    }

    private String getWikiPage() {
        return "XMPPSampler";
    }
}

