/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.xmpp;

import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Packet;

public class Loggers {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public static class LogConn
    implements ConnectionListener {
        private final XMPPConnection conn;

        public LogConn(XMPPConnection conn) {
            this.conn = conn;
        }

        public void connected(XMPPConnection connection) {
            log.debug("Connected: " + connection.getConnectionID());
        }

        public void authenticated(XMPPConnection connection) {
            log.debug("Authenticated: " + connection.getConnectionID());
        }

        public void connectionClosed() {
            log.debug("Connection closed: " + this.conn.getConnectionID());
        }

        public void connectionClosedOnError(Exception e) {
            log.error("Connection closed with error: " + this.conn.getConnectionID(), (Throwable)e);
        }

        public void reconnectingIn(int seconds) {
            log.debug("Reconnecting in: " + seconds);
        }

        public void reconnectionSuccessful() {
            log.debug("Reconnection successfull");
        }

        public void reconnectionFailed(Exception e) {
            log.error("Reconnection failed: ", (Throwable)e);
        }
    }

    public static class LogSent
    implements PacketListener {
        private final XMPPConnection conn;

        public LogSent(XMPPConnection conn) {
            this.conn = conn;
        }

        public void processPacket(Packet packet) throws SmackException.NotConnectedException {
            log.debug("Packet sent [" + this.conn.getConnectionID() + "]: " + packet.toXML());
        }
    }

    public static class LogRecv
    implements PacketListener {
        private final XMPPConnection conn;

        public LogRecv(XMPPConnection conn) {
            this.conn = conn;
        }

        public void processPacket(Packet packet) throws SmackException.NotConnectedException {
            try {
                log.debug("Packet recv [" + this.conn.getConnectionID() + "]: " + packet.toXML());
            }
            catch (IllegalArgumentException e) {
                log.debug("Failed to log packet", (Throwable)e);
                log.debug("Packet recv [" + this.conn.getConnectionID() + "]: " + packet.getError());
            }
        }
    }
}

