/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.xmpp.actions;

import com.blazemeter.jmeter.xmpp.JMeterXMPPSampler;
import com.blazemeter.jmeter.xmpp.actions.AbstractXMPPAction;
import java.awt.GridBagConstraints;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jivesoftware.smack.XMPPConnection;

public class Login
extends AbstractXMPPAction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String LOGIN = "login";
    public static final String PASSWORD = "password";
    public static final String RESOURCE = "resource";
    private JTextField login;
    private JTextField password;
    private JTextField resource;

    @Override
    public String getLabel() {
        return "Log In";
    }

    @Override
    public void addUI(JComponent panel, GridBagConstraints labelConstraints, GridBagConstraints editConstraints) {
        this.addToPanel(panel, labelConstraints, 0, 0, new JLabel("Username: ", 4));
        this.login = new JTextField(20);
        this.addToPanel(panel, editConstraints, 1, 0, this.login);
        this.addToPanel(panel, labelConstraints, 0, 1, new JLabel("Password: ", 4));
        this.password = new JTextField(20);
        this.addToPanel(panel, editConstraints, 1, 1, this.password);
        this.addToPanel(panel, labelConstraints, 0, 2, new JLabel("Resource: ", 4));
        this.resource = new JTextField(20);
        this.addToPanel(panel, editConstraints, 1, 2, this.resource);
    }

    @Override
    public SampleResult perform(JMeterXMPPSampler sampler, SampleResult res) throws Exception {
        XMPPConnection conn = sampler.getXMPPConnection();
        String loginStr = sampler.getPropertyAsString(LOGIN);
        String pwdStr = sampler.getPropertyAsString(PASSWORD);
        String resStr = sampler.getPropertyAsString(RESOURCE);
        res.setSamplerData("Username: " + loginStr + "\nPassword: " + pwdStr + "\nResource: " + resStr);
        if (loginStr.isEmpty()) {
            conn.loginAnonymously();
        } else {
            conn.login(loginStr, pwdStr, resStr);
        }
        return res;
    }

    @Override
    public void clearGui() {
        this.login.setText("");
        this.password.setText("");
        this.resource.setText("JMeter");
    }

    @Override
    public void setSamplerProperties(JMeterXMPPSampler sampler) {
        sampler.setProperty(LOGIN, this.login.getText());
        sampler.setProperty(PASSWORD, this.password.getText());
        sampler.setProperty(RESOURCE, this.resource.getText());
    }

    @Override
    public void setGuiFieldsFromSampler(JMeterXMPPSampler sampler) {
        this.login.setText(sampler.getPropertyAsString(LOGIN));
        this.password.setText(sampler.getPropertyAsString(PASSWORD));
        this.resource.setText(sampler.getPropertyAsString(RESOURCE));
    }
}

