/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.xmpp.actions;

import com.blazemeter.jmeter.xmpp.JMeterXMPPSampler;
import com.blazemeter.jmeter.xmpp.actions.AbstractXMPPAction;
import java.awt.GridBagConstraints;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.jmeter.samplers.SampleResult;
import org.jivesoftware.smackx.muc.MultiUserChat;

public class MUC
extends AbstractXMPPAction {
    private static final String ROOM = "muc_room";
    private static final String NICKNAME = "muc_nickname";
    private JTextField roomname;
    private JTextField nickname;

    @Override
    public String getLabel() {
        return "Join Multi-User Chat (XEP-0045)";
    }

    @Override
    public SampleResult perform(JMeterXMPPSampler sampler, SampleResult res) throws Exception {
        String room = sampler.getPropertyAsString(ROOM);
        String nick = sampler.getPropertyAsString(NICKNAME);
        res.setSamplerData("Join Room: " + room + "/" + nick);
        MultiUserChat muc = new MultiUserChat(sampler.getXMPPConnection(), room);
        muc.join(nick);
        return res;
    }

    @Override
    public void addUI(JComponent panel, GridBagConstraints labelConstraints, GridBagConstraints editConstraints) {
        this.addToPanel(panel, labelConstraints, 0, 0, new JLabel("Room: ", 4));
        this.roomname = new JTextField(20);
        this.addToPanel(panel, editConstraints, 1, 0, this.roomname);
        this.addToPanel(panel, labelConstraints, 0, 1, new JLabel("Nickname: ", 4));
        this.nickname = new JTextField(20);
        this.addToPanel(panel, editConstraints, 1, 1, this.nickname);
    }

    @Override
    public void clearGui() {
        this.roomname.setText("");
        this.nickname.setText("");
    }

    @Override
    public void setSamplerProperties(JMeterXMPPSampler sampler) {
        sampler.setProperty(ROOM, this.roomname.getText());
        sampler.setProperty(NICKNAME, this.nickname.getText());
    }

    @Override
    public void setGuiFieldsFromSampler(JMeterXMPPSampler sampler) {
        this.roomname.setText(sampler.getPropertyAsString(ROOM));
        this.nickname.setText(sampler.getPropertyAsString(NICKNAME));
    }
}

