/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.xmpp.actions;

import com.blazemeter.jmeter.xmpp.JMeterXMPPSampler;
import com.blazemeter.jmeter.xmpp.actions.AbstractXMPPAction;
import java.awt.GridBagConstraints;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.apache.jmeter.samplers.SampleResult;
import org.jivesoftware.smack.packet.Packet;

public class RawXML
extends AbstractXMPPAction {
    public static final String XML = "xml";
    private JTextArea msgBody;

    @Override
    public String getLabel() {
        return "Send Raw XML";
    }

    @Override
    public SampleResult perform(JMeterXMPPSampler sampler, SampleResult res) throws Exception {
        final String xml = sampler.getPropertyAsString(XML);
        res.setSamplerData(xml);
        sampler.getXMPPConnection().sendPacket(new Packet(){

            public CharSequence toXML() {
                return xml;
            }
        });
        return res;
    }

    @Override
    public void addUI(JComponent panel, GridBagConstraints labelConstraints, GridBagConstraints editConstraints) {
        this.addToPanel(panel, labelConstraints, 0, 2, new JLabel("XML to Send: ", 4));
        this.msgBody = new JTextArea(5, 20);
        this.addToPanel(panel, editConstraints, 1, 2, this.msgBody);
    }

    @Override
    public void clearGui() {
        this.msgBody.setText("");
    }

    @Override
    public void setSamplerProperties(JMeterXMPPSampler sampler) {
        sampler.setProperty(XML, this.msgBody.getText());
    }

    @Override
    public void setGuiFieldsFromSampler(JMeterXMPPSampler sampler) {
        this.msgBody.setText(sampler.getPropertyAsString(XML));
    }
}

