/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.xmpp.actions;

import com.blazemeter.jmeter.xmpp.JMeterXMPPSampler;
import com.blazemeter.jmeter.xmpp.actions.AbstractXMPPAction;
import java.awt.GridBagConstraints;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.jmeter.samplers.SampleResult;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;

public class RosterAction
extends AbstractXMPPAction {
    private static final String ENTRY = "roster_entry";
    private static final String ACTION = "roster_action";
    private JComboBox<Action> rosterAction;
    private JTextField rosterItem;

    @Override
    public String getLabel() {
        return "Roster Actions";
    }

    @Override
    public void addUI(JComponent mainPanel, GridBagConstraints labelConstraints, GridBagConstraints editConstraints) {
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("Type: ", 4));
        this.rosterAction = new JComboBox();
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.rosterAction);
        this.rosterAction.addItem(Action.get_roster);
        this.rosterAction.addItem(Action.add_item);
        this.rosterAction.addItem(Action.delete_item);
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("JID: ", 4));
        this.rosterItem = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.rosterItem);
    }

    @Override
    public SampleResult perform(JMeterXMPPSampler sampler, SampleResult res) throws Exception {
        RosterEntry rosterEntry;
        Action action = Action.valueOf(sampler.getPropertyAsString(ACTION, Action.get_roster.toString()));
        Roster roster = sampler.getXMPPConnection().getRoster();
        String entry = sampler.getPropertyAsString(ENTRY);
        res.setSamplerData(action.toString() + ": " + entry);
        if (action == Action.get_roster) {
            res.setResponseData(this.rosterToString(roster).getBytes());
        } else if (action == Action.add_item) {
            roster.createEntry(entry, entry, new String[0]);
        } else if (action == Action.delete_item && (rosterEntry = roster.getEntry(entry)) != null) {
            roster.removeEntry(rosterEntry);
        }
        return res;
    }

    @Override
    public void clearGui() {
        this.rosterAction.setSelectedIndex(0);
        this.rosterItem.setText("");
    }

    @Override
    public void setSamplerProperties(JMeterXMPPSampler sampler) {
        sampler.setProperty(ACTION, this.rosterAction.getSelectedItem().toString());
        sampler.setProperty(ENTRY, this.rosterItem.getText());
    }

    @Override
    public void setGuiFieldsFromSampler(JMeterXMPPSampler sampler) {
        this.rosterItem.setText(sampler.getPropertyAsString(ENTRY));
        this.rosterAction.setSelectedItem((Object)Action.valueOf(sampler.getPropertyAsString(ACTION, Action.get_roster.toString())));
    }

    private String rosterToString(Roster roster) {
        StringBuilder res = new StringBuilder();
        for (RosterEntry entry : roster.getEntries()) {
            res.append(entry.toString());
            res.append(':');
            res.append(roster.getPresence(entry.getUser()).toString());
            res.append('\n');
        }
        return res.toString();
    }

    public static enum Action {
        get_roster,
        add_item,
        delete_item;

    }
}

