/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.xmpp.actions;

import com.blazemeter.jmeter.xmpp.JMeterXMPPSampler;
import com.blazemeter.jmeter.xmpp.actions.AbstractXMPPAction;
import java.awt.GridBagConstraints;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferListener;
import org.jivesoftware.smackx.filetransfer.FileTransferManager;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;

public class SendFileXEP0096
extends AbstractXMPPAction
implements FileTransferListener,
ConnectionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String FILE_RECIPIENT = "file_recipient";
    public static final String FILE_PATH = "file_path";
    private static final long WAITING_CYCLES = 10L;
    private JTextField recipient;
    private JTextField path;
    private FileTransferManager mgr;

    @Override
    public String getLabel() {
        return "Send File (XEP-0096)";
    }

    @Override
    public SampleResult perform(JMeterXMPPSampler sampler, SampleResult res) throws Exception {
        String recipient = sampler.getPropertyAsString(FILE_RECIPIENT);
        String filePath = sampler.getPropertyAsString(FILE_PATH);
        res.setSamplerData("Recipient: " + recipient + "\r\nFile: " + filePath + "\r\n");
        OutgoingFileTransfer transfer = this.mgr.createOutgoingFileTransfer(recipient);
        transfer.sendFile(new File(filePath), filePath);
        this.waitForTransfer((FileTransfer)transfer, sampler.getXMPPConnection().getPacketReplyTimeout());
        res.setResponseData(("Bytes sent: " + transfer.getBytesSent()).getBytes());
        return res;
    }

    private void waitForTransfer(FileTransfer transfer, long timeout) throws SmackException, InterruptedException {
        double prevProgress = 0.0;
        long counter = 0L;
        Thread.sleep(timeout / 10L / 10L);
        while (!transfer.isDone()) {
            if (transfer.getStatus().equals((Object)FileTransfer.Status.error)) {
                throw new SmackException(transfer.getError().toString(), (Throwable)transfer.getException());
            }
            log.debug("Status: " + transfer.getStatus() + " " + transfer.getProgress());
            if (transfer.getProgress() <= prevProgress) {
                if (counter >= 10L) {
                    throw new SmackException("File transfer timed out");
                }
                ++counter;
                Thread.sleep(timeout / 10L);
                continue;
            }
            counter = 0L;
            prevProgress = transfer.getProgress();
        }
        if (transfer.getProgress() == 0.0) {
            throw new SmackException("No data transferred");
        }
    }

    @Override
    public void addUI(JComponent panel, GridBagConstraints labelConstraints, GridBagConstraints editConstraints) {
        this.addToPanel(panel, labelConstraints, 0, 0, new JLabel("Recipient: ", 4));
        this.recipient = new JTextField(20);
        this.addToPanel(panel, editConstraints, 1, 0, this.recipient);
        this.addToPanel(panel, labelConstraints, 0, 1, new JLabel("File to send: ", 4));
        this.path = new JTextField(20);
        this.addToPanel(panel, editConstraints, 1, 1, this.path);
        this.addToPanel(panel, labelConstraints, 1, 2, new JLabel("Note: you must use full JID as recipient, like user@server/resource)", 2));
    }

    @Override
    public void clearGui() {
        this.recipient.setText("");
        this.path.setText("");
    }

    @Override
    public void setSamplerProperties(JMeterXMPPSampler sampler) {
        sampler.setProperty(FILE_RECIPIENT, this.recipient.getText());
        sampler.setProperty(FILE_PATH, this.path.getText());
    }

    @Override
    public void setGuiFieldsFromSampler(JMeterXMPPSampler sampler) {
        this.recipient.setText(sampler.getPropertyAsString(FILE_RECIPIENT));
        this.path.setText(sampler.getPropertyAsString(FILE_PATH));
    }

    public void fileTransferRequest(FileTransferRequest request) {
        final IncomingFileTransfer transfer = request.accept();
        Thread transferThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    NullOutputStream os = new NullOutputStream();
                    InputStream is = transfer.recieveFile();
                    log.debug("Reading from stream: " + is.available());
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                    log.debug("Left in stream: " + is.available());
                }
                catch (Exception e) {
                    log.error("Failed incoming file transfer", (Throwable)e);
                }
            }
        });
        transferThread.start();
    }

    public void connected(XMPPConnection connection) {
        this.mgr = new FileTransferManager(connection);
        this.mgr.addFileTransferListener((FileTransferListener)this);
    }

    public void authenticated(XMPPConnection connection) {
    }

    public void connectionClosed() {
    }

    public void connectionClosedOnError(Exception e) {
    }

    public void reconnectingIn(int seconds) {
    }

    public void reconnectionSuccessful() {
    }

    public void reconnectionFailed(Exception e) {
    }
}

