/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.xmpp.actions;

import com.blazemeter.jmeter.xmpp.JMeterXMPPSampler;
import com.blazemeter.jmeter.xmpp.actions.AbstractXMPPAction;
import java.awt.GridBagConstraints;
import java.util.Date;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.delay.packet.DelayInfo;
import org.jivesoftware.smackx.delay.packet.DelayInformation;

public class SendMessage
extends AbstractXMPPAction
implements PacketListener,
ConnectionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String RECIPIENT = "msg_w_resp_addressee";
    public static final String BODY = "msg_w_resp_body";
    public static final String WAIT_RESPONSE = "wait_response";
    public static final String TYPE = "msg_type";
    public static final String NEED_RESPONSE_MARKER = "ExpectedResponseMarker";
    public static final String RESPONSE_MARKER = "ProvidedResponseMarker";
    private static final String NS_DELAYED = new DelayInfo(new DelayInformation(new Date())).getNamespace();
    private JTextField msgRecipient;
    private JTextArea msgBody;
    private JCheckBox waitResponse;
    private JComboBox<Message.Type> msgType;
    private Queue<Message> responseMessages = new LinkedBlockingQueue<Message>();
    private XMPPConnection conn;

    @Override
    public String getLabel() {
        return "Send Message";
    }

    @Override
    public SampleResult perform(JMeterXMPPSampler sampler, SampleResult res) throws Exception {
        String recipient = sampler.getPropertyAsString(RECIPIENT);
        String body = sampler.getPropertyAsString(BODY);
        boolean wait_response = sampler.getPropertyAsBoolean(WAIT_RESPONSE);
        if (wait_response) {
            body = body + "\r\n" + System.currentTimeMillis() + "@" + NEED_RESPONSE_MARKER;
        }
        Message msg = new Message(recipient);
        msg.setType(Message.Type.fromString((String)sampler.getPropertyAsString(TYPE, Message.Type.normal.toString())));
        msg.addBody("", body);
        res.setSamplerData(msg.toXML().toString());
        sampler.getXMPPConnection().sendPacket((Packet)msg);
        res.setSamplerData(msg.toXML().toString());
        if (wait_response) {
            return this.waitResponse(res, recipient);
        }
        return res;
    }

    private SampleResult waitResponse(SampleResult res, String recipient) throws InterruptedException, SmackException {
        long time = 0L;
        do {
            Iterator packets = this.responseMessages.iterator();
            Thread.sleep(this.conn.getPacketReplyTimeout() / 100L);
            while (packets.hasNext()) {
                Packet packet = (Packet)packets.next();
                Message response = (Message)packet;
                if (!StringUtils.parseBareAddress((String)response.getFrom()).equals(recipient)) continue;
                packets.remove();
                res.setResponseData(response.toXML().toString().getBytes());
                if (response.getError() != null) {
                    res.setSuccessful(false);
                    res.setResponseCode("500");
                    res.setResponseMessage(response.getError().toString());
                }
                return res;
            }
            Thread.sleep(this.conn.getPacketReplyTimeout() / 10L);
        } while ((time += this.conn.getPacketReplyTimeout() / 10L) < this.conn.getPacketReplyTimeout());
        throw new SmackException.NoResponseException();
    }

    @Override
    public void addUI(JComponent mainPanel, GridBagConstraints labelConstraints, GridBagConstraints editConstraints) {
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("Type: ", 4));
        this.msgType = new JComboBox();
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.msgType);
        this.msgType.addItem(Message.Type.normal);
        this.msgType.addItem(Message.Type.chat);
        this.msgType.addItem(Message.Type.groupchat);
        this.msgType.addItem(Message.Type.headline);
        this.msgType.addItem(Message.Type.error);
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("Recipient: ", 4));
        this.msgRecipient = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.msgRecipient);
        this.addToPanel(mainPanel, labelConstraints, 0, 2, new JLabel("Message Text: ", 4));
        this.msgBody = new JTextArea(5, 20);
        this.addToPanel(mainPanel, editConstraints, 1, 2, this.msgBody);
        this.addToPanel(mainPanel, labelConstraints, 0, 3, new JLabel("Wait for Response: ", 4));
        this.waitResponse = new JCheckBox("(message that expects response should be auto-responded by another JMeter thread)");
        this.addToPanel(mainPanel, editConstraints, 1, 3, this.waitResponse);
    }

    @Override
    public void clearGui() {
        this.msgRecipient.setText("");
        this.msgBody.setText("");
        this.waitResponse.setSelected(false);
        this.msgType.setSelectedIndex(0);
    }

    @Override
    public void setSamplerProperties(JMeterXMPPSampler sampler) {
        sampler.setProperty(RECIPIENT, this.msgRecipient.getText());
        sampler.setProperty(BODY, this.msgBody.getText());
        sampler.setProperty(WAIT_RESPONSE, this.waitResponse.isSelected());
        sampler.setProperty(TYPE, this.msgType.getSelectedItem().toString());
    }

    @Override
    public void setGuiFieldsFromSampler(JMeterXMPPSampler sampler) {
        this.msgRecipient.setText(sampler.getPropertyAsString(RECIPIENT));
        this.msgBody.setText(sampler.getPropertyAsString(BODY));
        this.waitResponse.setSelected(sampler.getPropertyAsBoolean(WAIT_RESPONSE));
        this.msgType.setSelectedItem(Message.Type.fromString((String)sampler.getPropertyAsString(TYPE, Message.Type.normal.toString())));
    }

    public void processPacket(Packet packet) throws SmackException.NotConnectedException {
        Message inMsg;
        if (packet instanceof Message && (inMsg = (Message)packet).getBody() != null) {
            if (inMsg.getBody().endsWith(NEED_RESPONSE_MARKER)) {
                if (inMsg.getExtension(NS_DELAYED) == null) {
                    log.debug("Will respond to message: " + inMsg.toXML());
                    this.sendResponseMessage(inMsg);
                } else {
                    log.debug("Will not consider history message: " + inMsg.toXML());
                }
            } else if (inMsg.getBody().endsWith(RESPONSE_MARKER)) {
                this.responseMessages.add(inMsg);
            }
        }
    }

    private void sendResponseMessage(Message inMsg) {
        Message outMsg = new Message(inMsg.getFrom());
        outMsg.setType(inMsg.getType());
        outMsg.addBody("", inMsg.getBody() + "\r\n" + System.currentTimeMillis() + "@" + RESPONSE_MARKER);
        log.debug("Responding to message: " + outMsg.toXML());
        try {
            this.conn.sendPacket((Packet)outMsg);
        }
        catch (SmackException e) {
            log.error("Failed to send response", (Throwable)e);
        }
    }

    public void connected(XMPPConnection connection) {
        this.conn = connection;
    }

    public void authenticated(XMPPConnection connection) {
    }

    public void connectionClosed() {
    }

    public void connectionClosedOnError(Exception e) {
    }

    public void reconnectingIn(int seconds) {
    }

    public void reconnectionSuccessful() {
    }

    public void reconnectionFailed(Exception e) {
    }
}

