/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.xmpp.actions;

import com.blazemeter.jmeter.xmpp.JMeterXMPPSampler;
import com.blazemeter.jmeter.xmpp.actions.AbstractXMPPAction;
import java.awt.GridBagConstraints;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.jmeter.samplers.SampleResult;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

public class SendPresence
extends AbstractXMPPAction
implements PacketListener {
    public static final String RECIPIENT = "recipient";
    public static final String STATUS_TEXT = "text";
    public static final String TYPE = "type";
    public static final String MODE = "mode";
    private JTextField recipient;
    private JTextField text;
    private JComboBox<Presence.Type> type;
    private JComboBox<Presence.Mode> mode;

    @Override
    public String getLabel() {
        return "Send Presence";
    }

    @Override
    public SampleResult perform(JMeterXMPPSampler sampler, SampleResult res) throws Exception {
        String text;
        Presence.Type typeVal = Presence.Type.valueOf((String)sampler.getPropertyAsString(TYPE, Presence.Type.available.toString()));
        Presence.Mode modeVal = Presence.Mode.valueOf((String)sampler.getPropertyAsString(MODE, Presence.Mode.available.toString()));
        Presence presence = new Presence(typeVal);
        presence.setMode(modeVal);
        String to = sampler.getPropertyAsString(RECIPIENT);
        if (!to.isEmpty()) {
            presence.setTo(to);
        }
        if (!(text = sampler.getPropertyAsString(STATUS_TEXT)).isEmpty()) {
            presence.setStatus(text);
        }
        sampler.getXMPPConnection().sendPacket((Packet)presence);
        res.setSamplerData(presence.toXML().toString());
        return res;
    }

    @Override
    public void addUI(JComponent mainPanel, GridBagConstraints labelConstraints, GridBagConstraints editConstraints) {
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("Type: ", 4));
        this.type = new JComboBox();
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.type);
        this.type.addItem(Presence.Type.available);
        this.type.addItem(Presence.Type.unavailable);
        this.type.addItem(Presence.Type.subscribe);
        this.type.addItem(Presence.Type.unsubscribe);
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("Status: ", 4));
        this.mode = new JComboBox();
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.mode);
        this.mode.addItem(Presence.Mode.available);
        this.mode.addItem(Presence.Mode.away);
        this.mode.addItem(Presence.Mode.chat);
        this.mode.addItem(Presence.Mode.dnd);
        this.mode.addItem(Presence.Mode.xa);
        this.addToPanel(mainPanel, labelConstraints, 0, 2, new JLabel("Text: ", 4));
        this.text = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 2, this.text);
        this.addToPanel(mainPanel, labelConstraints, 0, 3, new JLabel("Recipient: ", 4));
        this.recipient = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 3, this.recipient);
    }

    @Override
    public void clearGui() {
        this.recipient.setText("");
        this.text.setText("");
        this.type.setSelectedIndex(0);
        this.mode.setSelectedIndex(0);
    }

    @Override
    public void setSamplerProperties(JMeterXMPPSampler sampler) {
        sampler.setProperty(RECIPIENT, this.recipient.getText());
        sampler.setProperty(STATUS_TEXT, this.text.getText());
        sampler.setProperty(TYPE, this.type.getSelectedItem().toString());
        sampler.setProperty(MODE, this.mode.getSelectedItem().toString());
    }

    @Override
    public void setGuiFieldsFromSampler(JMeterXMPPSampler sampler) {
        this.recipient.setText(sampler.getPropertyAsString(RECIPIENT));
        this.text.setText(sampler.getPropertyAsString(STATUS_TEXT));
        this.type.setSelectedItem(Presence.Type.valueOf((String)sampler.getPropertyAsString(TYPE, Presence.Type.available.toString())));
        this.mode.setSelectedItem(Presence.Mode.valueOf((String)sampler.getPropertyAsString(MODE, Presence.Mode.available.toString())));
    }

    public void processPacket(Packet packet) throws SmackException.NotConnectedException {
    }
}

