/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.xmpp.actions;

import com.blazemeter.jmeter.xmpp.JMeterXMPPSampler;
import com.blazemeter.jmeter.xmpp.actions.AbstractXMPPAction;
import java.awt.GridBagConstraints;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.jmeter.samplers.SampleResult;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public class ServiceDiscovery
extends AbstractXMPPAction {
    private static final String ENTITY_ID = "entity_id";
    private static final String TYPE = "discovery_type";
    private JTextField entityID;
    private JComboBox<String> discoType;

    @Override
    public String getLabel() {
        return "Service Discovery (XEP-0030)";
    }

    @Override
    public SampleResult perform(JMeterXMPPSampler sampler, SampleResult res) throws Exception {
        String entID = sampler.getPropertyAsString(ENTITY_ID);
        res.setSamplerData("Entity ID: " + entID);
        ServiceDiscoveryManager discoMgr = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)sampler.getXMPPConnection());
        Object info = Type.valueOf(sampler.getPropertyAsString(TYPE)) == Type.info ? discoMgr.discoverInfo(entID) : discoMgr.discoverItems(entID);
        res.setResponseData(info.toXML().toString().getBytes());
        return res;
    }

    @Override
    public void addUI(JComponent panel, GridBagConstraints labelConstraints, GridBagConstraints editConstraints) {
        this.addToPanel(panel, labelConstraints, 0, 0, new JLabel("Entity ID: ", 4));
        this.entityID = new JTextField(20);
        this.addToPanel(panel, editConstraints, 1, 0, this.entityID);
        this.addToPanel(panel, labelConstraints, 0, 1, new JLabel("Type: ", 4));
        this.discoType = new JComboBox();
        this.addToPanel(panel, editConstraints, 1, 1, this.discoType);
        this.discoType.addItem(Type.items.toString());
        this.discoType.addItem(Type.info.toString());
    }

    @Override
    public void clearGui() {
        this.entityID.setText("");
        this.discoType.setSelectedIndex(0);
    }

    @Override
    public void setSamplerProperties(JMeterXMPPSampler sampler) {
        sampler.setProperty(ENTITY_ID, this.entityID.getText());
        sampler.setProperty(TYPE, this.discoType.getSelectedItem().toString());
    }

    @Override
    public void setGuiFieldsFromSampler(JMeterXMPPSampler sampler) {
        this.entityID.setText(sampler.getPropertyAsString(ENTITY_ID));
        this.discoType.setSelectedItem((Object)Type.valueOf(sampler.getPropertyAsString(TYPE, Type.items.toString())));
    }

    public static enum Type {
        info,
        items;

    }
}

