/*
 * Decompiled with CFR 0.152.
 */
package tendermint.types;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.Timestamp;
import google.protobuf.TimestampJvmConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kr.jadekim.protobuf.converter.mapper.ProtobufTypeMapper;
import kr.jadekim.protobuf.type.ProtobufMessage;
import org.jetbrains.annotations.NotNull;
import tendermint.types.BlockIDFlag;
import tendermint.types.CommitSig;
import tendermint.types.Types;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Ltendermint/types/CommitSigJvmConverter;", "Lkr/jadekim/protobuf/converter/mapper/ProtobufTypeMapper;", "Ltendermint/types/CommitSig;", "Ltendermint/types/Types$CommitSig;", "()V", "descriptor", "Lcom/google/protobuf/Descriptors$Descriptor;", "getDescriptor", "()Lcom/google/protobuf/Descriptors$Descriptor;", "parser", "Lcom/google/protobuf/Parser;", "getParser", "()Lcom/google/protobuf/Parser;", "convert", "obj", "cosmos-proto-kotlin"})
public final class CommitSigJvmConverter
implements ProtobufTypeMapper<CommitSig, Types.CommitSig> {
    @NotNull
    public static final CommitSigJvmConverter INSTANCE = new CommitSigJvmConverter();
    @NotNull
    private static final Descriptors.Descriptor descriptor;
    @NotNull
    private static final Parser<Types.CommitSig> parser;

    private CommitSigJvmConverter() {
    }

    @NotNull
    public Descriptors.Descriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public Parser<Types.CommitSig> getParser() {
        return parser;
    }

    @NotNull
    public CommitSig convert(@NotNull Types.CommitSig obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        BlockIDFlag blockIDFlag = BlockIDFlag.Companion.forNumber(obj.getBlockIdFlag().getNumber());
        byte[] byArray = obj.getValidatorAddress().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"obj.getValidatorAddress().toByteArray()");
        Timestamp timestamp = obj.getTimestamp();
        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"obj.getTimestamp()");
        google.protobuf.Timestamp timestamp2 = TimestampJvmConverter.INSTANCE.convert(timestamp);
        byte[] byArray2 = obj.getSignature().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"obj.getSignature().toByteArray()");
        return new CommitSig(blockIDFlag, byArray, timestamp2, byArray2);
    }

    @NotNull
    public Types.CommitSig convert(@NotNull CommitSig obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Types.CommitSig.Builder builder = Types.CommitSig.newBuilder();
        builder.setBlockIdFlag(Types.BlockIDFlag.forNumber((int)obj.getBlockIdFlag().getNumber()));
        builder.setValidatorAddress(ByteString.copyFrom((byte[])obj.getValidatorAddress()));
        builder.setTimestamp(TimestampJvmConverter.INSTANCE.convert(obj.getTimestamp()));
        builder.setSignature(ByteString.copyFrom((byte[])obj.getSignature()));
        Types.CommitSig commitSig = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)commitSig, (String)"builder.build()");
        return commitSig;
    }

    @NotNull
    public CommitSig deserialize(@NotNull byte[] bytes) {
        return (CommitSig)ProtobufTypeMapper.DefaultImpls.deserialize((ProtobufTypeMapper)this, (byte[])bytes);
    }

    @NotNull
    public byte[] serialize(@NotNull CommitSig obj) {
        return ProtobufTypeMapper.DefaultImpls.serialize((ProtobufTypeMapper)this, (ProtobufMessage)obj);
    }

    @NotNull
    public CommitSig fromDelegator(@NotNull Types.CommitSig $this$fromDelegator) {
        return (CommitSig)ProtobufTypeMapper.DefaultImpls.fromDelegator((ProtobufTypeMapper)this, (Message)((Message)$this$fromDelegator));
    }

    @NotNull
    public byte[] toByteArray(@NotNull CommitSig $this$toByteArray) {
        return ProtobufTypeMapper.DefaultImpls.toByteArray((ProtobufTypeMapper)this, (ProtobufMessage)$this$toByteArray);
    }

    @NotNull
    public Types.CommitSig toDelegator(@NotNull CommitSig $this$toDelegator) {
        return (Types.CommitSig)ProtobufTypeMapper.DefaultImpls.toDelegator((ProtobufTypeMapper)this, (ProtobufMessage)$this$toDelegator);
    }

    static {
        Descriptors.Descriptor descriptor = Types.CommitSig.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)descriptor, (String)"getDescriptor()");
        CommitSigJvmConverter.descriptor = descriptor;
        Parser parser = Types.CommitSig.parser();
        Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser()");
        CommitSigJvmConverter.parser = parser;
    }
}

