/*
 * Decompiled with CFR 0.152.
 */
package tendermint.types;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import google.protobuf.Timestamp;
import google.protobuf.TimestampJvmConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kr.jadekim.protobuf.converter.mapper.ProtobufTypeMapper;
import kr.jadekim.protobuf.type.ProtobufMessage;
import org.jetbrains.annotations.NotNull;
import tendermint.types.BlockID;
import tendermint.types.BlockIDJvmConverter;
import tendermint.types.Header;
import tendermint.types.Types;
import tendermint.version.Consensus;
import tendermint.version.ConsensusJvmConverter;
import tendermint.version.Types;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Ltendermint/types/HeaderJvmConverter;", "Lkr/jadekim/protobuf/converter/mapper/ProtobufTypeMapper;", "Ltendermint/types/Header;", "Ltendermint/types/Types$Header;", "()V", "descriptor", "Lcom/google/protobuf/Descriptors$Descriptor;", "getDescriptor", "()Lcom/google/protobuf/Descriptors$Descriptor;", "parser", "Lcom/google/protobuf/Parser;", "getParser", "()Lcom/google/protobuf/Parser;", "convert", "obj", "cosmos-proto-kotlin"})
public final class HeaderJvmConverter
implements ProtobufTypeMapper<Header, Types.Header> {
    @NotNull
    public static final HeaderJvmConverter INSTANCE = new HeaderJvmConverter();
    @NotNull
    private static final Descriptors.Descriptor descriptor;
    @NotNull
    private static final Parser<Types.Header> parser;

    private HeaderJvmConverter() {
    }

    @NotNull
    public Descriptors.Descriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public Parser<Types.Header> getParser() {
        return parser;
    }

    @NotNull
    public Header convert(@NotNull Types.Header obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Types.Consensus consensus = obj.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)consensus, (String)"obj.getVersion()");
        Consensus consensus2 = ConsensusJvmConverter.INSTANCE.convert(consensus);
        String string = obj.getChainId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"obj.getChainId()");
        long l = obj.getHeight();
        com.google.protobuf.Timestamp timestamp = obj.getTime();
        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"obj.getTime()");
        Timestamp timestamp2 = TimestampJvmConverter.INSTANCE.convert(timestamp);
        Types.BlockID blockID = obj.getLastBlockId();
        Intrinsics.checkNotNullExpressionValue((Object)blockID, (String)"obj.getLastBlockId()");
        BlockID blockID2 = BlockIDJvmConverter.INSTANCE.convert(blockID);
        byte[] byArray = obj.getLastCommitHash().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"obj.getLastCommitHash().toByteArray()");
        byte[] byArray2 = obj.getDataHash().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"obj.getDataHash().toByteArray()");
        byte[] byArray3 = obj.getValidatorsHash().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"obj.getValidatorsHash().toByteArray()");
        byte[] byArray4 = obj.getNextValidatorsHash().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"obj.getNextValidatorsHash().toByteArray()");
        byte[] byArray5 = obj.getConsensusHash().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"obj.getConsensusHash().toByteArray()");
        byte[] byArray6 = obj.getAppHash().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray6, (String)"obj.getAppHash().toByteArray()");
        byte[] byArray7 = obj.getLastResultsHash().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray7, (String)"obj.getLastResultsHash().toByteArray()");
        byte[] byArray8 = obj.getEvidenceHash().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray8, (String)"obj.getEvidenceHash().toByteArray()");
        byte[] byArray9 = obj.getProposerAddress().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray9, (String)"obj.getProposerAddress().toByteArray()");
        return new Header(consensus2, string, l, timestamp2, blockID2, byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8, byArray9);
    }

    @NotNull
    public Types.Header convert(@NotNull Header obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Types.Header.Builder builder = Types.Header.newBuilder();
        builder.setVersion(ConsensusJvmConverter.INSTANCE.convert(obj.getVersion()));
        builder.setChainId(obj.getChainId());
        builder.setHeight(obj.getHeight());
        builder.setTime(TimestampJvmConverter.INSTANCE.convert(obj.getTime()));
        builder.setLastBlockId(BlockIDJvmConverter.INSTANCE.convert(obj.getLastBlockId()));
        builder.setLastCommitHash(ByteString.copyFrom((byte[])obj.getLastCommitHash()));
        builder.setDataHash(ByteString.copyFrom((byte[])obj.getDataHash()));
        builder.setValidatorsHash(ByteString.copyFrom((byte[])obj.getValidatorsHash()));
        builder.setNextValidatorsHash(ByteString.copyFrom((byte[])obj.getNextValidatorsHash()));
        builder.setConsensusHash(ByteString.copyFrom((byte[])obj.getConsensusHash()));
        builder.setAppHash(ByteString.copyFrom((byte[])obj.getAppHash()));
        builder.setLastResultsHash(ByteString.copyFrom((byte[])obj.getLastResultsHash()));
        builder.setEvidenceHash(ByteString.copyFrom((byte[])obj.getEvidenceHash()));
        builder.setProposerAddress(ByteString.copyFrom((byte[])obj.getProposerAddress()));
        Types.Header header = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)header, (String)"builder.build()");
        return header;
    }

    @NotNull
    public Header deserialize(@NotNull byte[] bytes) {
        return (Header)ProtobufTypeMapper.DefaultImpls.deserialize((ProtobufTypeMapper)this, (byte[])bytes);
    }

    @NotNull
    public byte[] serialize(@NotNull Header obj) {
        return ProtobufTypeMapper.DefaultImpls.serialize((ProtobufTypeMapper)this, (ProtobufMessage)obj);
    }

    @NotNull
    public Header fromDelegator(@NotNull Types.Header $this$fromDelegator) {
        return (Header)ProtobufTypeMapper.DefaultImpls.fromDelegator((ProtobufTypeMapper)this, (Message)((Message)$this$fromDelegator));
    }

    @NotNull
    public byte[] toByteArray(@NotNull Header $this$toByteArray) {
        return ProtobufTypeMapper.DefaultImpls.toByteArray((ProtobufTypeMapper)this, (ProtobufMessage)$this$toByteArray);
    }

    @NotNull
    public Types.Header toDelegator(@NotNull Header $this$toDelegator) {
        return (Types.Header)ProtobufTypeMapper.DefaultImpls.toDelegator((ProtobufTypeMapper)this, (ProtobufMessage)$this$toDelegator);
    }

    static {
        Descriptors.Descriptor descriptor = Types.Header.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)descriptor, (String)"getDescriptor()");
        HeaderJvmConverter.descriptor = descriptor;
        Parser parser = Types.Header.parser();
        Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser()");
        HeaderJvmConverter.parser = parser;
    }
}

