/*
 * Decompiled with CFR 0.152.
 */
package tendermint.types;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.Timestamp;
import google.protobuf.TimestampJvmConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kr.jadekim.protobuf.converter.mapper.ProtobufTypeMapper;
import kr.jadekim.protobuf.type.ProtobufMessage;
import org.jetbrains.annotations.NotNull;
import tendermint.types.BlockID;
import tendermint.types.BlockIDJvmConverter;
import tendermint.types.Proposal;
import tendermint.types.SignedMsgType;
import tendermint.types.Types;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Ltendermint/types/ProposalJvmConverter;", "Lkr/jadekim/protobuf/converter/mapper/ProtobufTypeMapper;", "Ltendermint/types/Proposal;", "Ltendermint/types/Types$Proposal;", "()V", "descriptor", "Lcom/google/protobuf/Descriptors$Descriptor;", "getDescriptor", "()Lcom/google/protobuf/Descriptors$Descriptor;", "parser", "Lcom/google/protobuf/Parser;", "getParser", "()Lcom/google/protobuf/Parser;", "convert", "obj", "cosmos-proto-kotlin"})
public final class ProposalJvmConverter
implements ProtobufTypeMapper<Proposal, Types.Proposal> {
    @NotNull
    public static final ProposalJvmConverter INSTANCE = new ProposalJvmConverter();
    @NotNull
    private static final Descriptors.Descriptor descriptor;
    @NotNull
    private static final Parser<Types.Proposal> parser;

    private ProposalJvmConverter() {
    }

    @NotNull
    public Descriptors.Descriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public Parser<Types.Proposal> getParser() {
        return parser;
    }

    @NotNull
    public Proposal convert(@NotNull Types.Proposal obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        SignedMsgType signedMsgType = SignedMsgType.Companion.forNumber(obj.getType().getNumber());
        long l = obj.getHeight();
        int n = obj.getRound();
        int n2 = obj.getPolRound();
        Types.BlockID blockID = obj.getBlockId();
        Intrinsics.checkNotNullExpressionValue((Object)blockID, (String)"obj.getBlockId()");
        BlockID blockID2 = BlockIDJvmConverter.INSTANCE.convert(blockID);
        Timestamp timestamp = obj.getTimestamp();
        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"obj.getTimestamp()");
        google.protobuf.Timestamp timestamp2 = TimestampJvmConverter.INSTANCE.convert(timestamp);
        byte[] byArray = obj.getSignature().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"obj.getSignature().toByteArray()");
        return new Proposal(signedMsgType, l, n, n2, blockID2, timestamp2, byArray);
    }

    @NotNull
    public Types.Proposal convert(@NotNull Proposal obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Types.Proposal.Builder builder = Types.Proposal.newBuilder();
        builder.setType(Types.SignedMsgType.forNumber((int)obj.getType().getNumber()));
        builder.setHeight(obj.getHeight());
        builder.setRound(obj.getRound());
        builder.setPolRound(obj.getPolRound());
        builder.setBlockId(BlockIDJvmConverter.INSTANCE.convert(obj.getBlockId()));
        builder.setTimestamp(TimestampJvmConverter.INSTANCE.convert(obj.getTimestamp()));
        builder.setSignature(ByteString.copyFrom((byte[])obj.getSignature()));
        Types.Proposal proposal = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)proposal, (String)"builder.build()");
        return proposal;
    }

    @NotNull
    public Proposal deserialize(@NotNull byte[] bytes) {
        return (Proposal)ProtobufTypeMapper.DefaultImpls.deserialize((ProtobufTypeMapper)this, (byte[])bytes);
    }

    @NotNull
    public byte[] serialize(@NotNull Proposal obj) {
        return ProtobufTypeMapper.DefaultImpls.serialize((ProtobufTypeMapper)this, (ProtobufMessage)obj);
    }

    @NotNull
    public Proposal fromDelegator(@NotNull Types.Proposal $this$fromDelegator) {
        return (Proposal)ProtobufTypeMapper.DefaultImpls.fromDelegator((ProtobufTypeMapper)this, (Message)((Message)$this$fromDelegator));
    }

    @NotNull
    public byte[] toByteArray(@NotNull Proposal $this$toByteArray) {
        return ProtobufTypeMapper.DefaultImpls.toByteArray((ProtobufTypeMapper)this, (ProtobufMessage)$this$toByteArray);
    }

    @NotNull
    public Types.Proposal toDelegator(@NotNull Proposal $this$toDelegator) {
        return (Types.Proposal)ProtobufTypeMapper.DefaultImpls.toDelegator((ProtobufTypeMapper)this, (ProtobufMessage)$this$toDelegator);
    }

    static {
        Descriptors.Descriptor descriptor = Types.Proposal.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)descriptor, (String)"getDescriptor()");
        ProposalJvmConverter.descriptor = descriptor;
        Parser parser = Types.Proposal.parser();
        Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser()");
        ProposalJvmConverter.parser = parser;
    }
}

