/*
 * Decompiled with CFR 0.152.
 */
package tendermint.types;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.Timestamp;
import google.protobuf.TimestampJvmConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kr.jadekim.protobuf.converter.mapper.ProtobufTypeMapper;
import kr.jadekim.protobuf.type.ProtobufMessage;
import org.jetbrains.annotations.NotNull;
import tendermint.types.BlockID;
import tendermint.types.BlockIDJvmConverter;
import tendermint.types.SignedMsgType;
import tendermint.types.Types;
import tendermint.types.Vote;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Ltendermint/types/VoteJvmConverter;", "Lkr/jadekim/protobuf/converter/mapper/ProtobufTypeMapper;", "Ltendermint/types/Vote;", "Ltendermint/types/Types$Vote;", "()V", "descriptor", "Lcom/google/protobuf/Descriptors$Descriptor;", "getDescriptor", "()Lcom/google/protobuf/Descriptors$Descriptor;", "parser", "Lcom/google/protobuf/Parser;", "getParser", "()Lcom/google/protobuf/Parser;", "convert", "obj", "cosmos-proto-kotlin"})
public final class VoteJvmConverter
implements ProtobufTypeMapper<Vote, Types.Vote> {
    @NotNull
    public static final VoteJvmConverter INSTANCE = new VoteJvmConverter();
    @NotNull
    private static final Descriptors.Descriptor descriptor;
    @NotNull
    private static final Parser<Types.Vote> parser;

    private VoteJvmConverter() {
    }

    @NotNull
    public Descriptors.Descriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public Parser<Types.Vote> getParser() {
        return parser;
    }

    @NotNull
    public Vote convert(@NotNull Types.Vote obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        SignedMsgType signedMsgType = SignedMsgType.Companion.forNumber(obj.getType().getNumber());
        long l = obj.getHeight();
        int n = obj.getRound();
        Types.BlockID blockID = obj.getBlockId();
        Intrinsics.checkNotNullExpressionValue((Object)blockID, (String)"obj.getBlockId()");
        BlockID blockID2 = BlockIDJvmConverter.INSTANCE.convert(blockID);
        Timestamp timestamp = obj.getTimestamp();
        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"obj.getTimestamp()");
        google.protobuf.Timestamp timestamp2 = TimestampJvmConverter.INSTANCE.convert(timestamp);
        byte[] byArray = obj.getValidatorAddress().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"obj.getValidatorAddress().toByteArray()");
        int n2 = obj.getValidatorIndex();
        byte[] byArray2 = obj.getSignature().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"obj.getSignature().toByteArray()");
        return new Vote(signedMsgType, l, n, blockID2, timestamp2, byArray, n2, byArray2);
    }

    @NotNull
    public Types.Vote convert(@NotNull Vote obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Types.Vote.Builder builder = Types.Vote.newBuilder();
        builder.setType(Types.SignedMsgType.forNumber((int)obj.getType().getNumber()));
        builder.setHeight(obj.getHeight());
        builder.setRound(obj.getRound());
        builder.setBlockId(BlockIDJvmConverter.INSTANCE.convert(obj.getBlockId()));
        builder.setTimestamp(TimestampJvmConverter.INSTANCE.convert(obj.getTimestamp()));
        builder.setValidatorAddress(ByteString.copyFrom((byte[])obj.getValidatorAddress()));
        builder.setValidatorIndex(obj.getValidatorIndex());
        builder.setSignature(ByteString.copyFrom((byte[])obj.getSignature()));
        Types.Vote vote = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)vote, (String)"builder.build()");
        return vote;
    }

    @NotNull
    public Vote deserialize(@NotNull byte[] bytes) {
        return (Vote)ProtobufTypeMapper.DefaultImpls.deserialize((ProtobufTypeMapper)this, (byte[])bytes);
    }

    @NotNull
    public byte[] serialize(@NotNull Vote obj) {
        return ProtobufTypeMapper.DefaultImpls.serialize((ProtobufTypeMapper)this, (ProtobufMessage)obj);
    }

    @NotNull
    public Vote fromDelegator(@NotNull Types.Vote $this$fromDelegator) {
        return (Vote)ProtobufTypeMapper.DefaultImpls.fromDelegator((ProtobufTypeMapper)this, (Message)((Message)$this$fromDelegator));
    }

    @NotNull
    public byte[] toByteArray(@NotNull Vote $this$toByteArray) {
        return ProtobufTypeMapper.DefaultImpls.toByteArray((ProtobufTypeMapper)this, (ProtobufMessage)$this$toByteArray);
    }

    @NotNull
    public Types.Vote toDelegator(@NotNull Vote $this$toDelegator) {
        return (Types.Vote)ProtobufTypeMapper.DefaultImpls.toDelegator((ProtobufTypeMapper)this, (ProtobufMessage)$this$toDelegator);
    }

    static {
        Descriptors.Descriptor descriptor = Types.Vote.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)descriptor, (String)"getDescriptor()");
        VoteJvmConverter.descriptor = descriptor;
        Parser parser = Types.Vote.parser();
        Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser()");
        VoteJvmConverter.parser = parser;
    }
}

