/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.stats;

import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import kr.jm.utils.datastructure.JMCollections;
import kr.jm.utils.helper.JMStream;
import kr.jm.utils.helper.JMString;
import kr.jm.utils.stats.StatsField;

public class JMStats {
    public static Number calStats(String statsString, IntSummaryStatistics summaryStatistics) {
        return StatsField.valueOfAlias(statsString).calStats(summaryStatistics);
    }

    public static Number calStats(String statsString, LongSummaryStatistics summaryStatistics) {
        return StatsField.valueOfAlias(statsString).calStats(summaryStatistics);
    }

    public static Number calStats(String statsString, DoubleSummaryStatistics summaryStatistics) {
        return StatsField.valueOfAlias(statsString).calStats(summaryStatistics);
    }

    public static Number calStats(String statsString, IntStream numberStream) {
        return StatsField.valueOfAlias(statsString).calStats(numberStream);
    }

    public static Number calStats(String statsString, LongStream numberStream) {
        return StatsField.valueOfAlias(statsString).calStats(numberStream);
    }

    public static Number calStats(String statsString, DoubleStream numberStream) {
        return StatsField.valueOfAlias(statsString).calStats(numberStream);
    }

    public static Number getPercentileValue(int targetPercentile, List<Number> unorderedNumberList) {
        return JMStats.getPercentileValueWithSorted(targetPercentile, JMStats.sortedDoubleList(unorderedNumberList));
    }

    private static Double getPercentileValueWithSorted(int targetPercentile, List<Double> sortedNumberList) {
        return JMStats.getPercentileValue(targetPercentile, sortedNumberList.size(), sortedNumberList);
    }

    public static Map<Integer, Number> getPercentileValueMap(List<Integer> targetPercentileList, List<Number> numberList) {
        List<Double> sortedDoubleList = JMStats.sortedDoubleList(numberList);
        return targetPercentileList.stream().collect(Collectors.toMap(percentile -> percentile, percentile -> JMStats.getPercentileValueWithSorted(percentile, sortedDoubleList)));
    }

    private static double getPercentileValue(int targetPercentile, int size, List<Double> sortedList) {
        int index = size * JMStats.adjustTargetPercentile(targetPercentile) / 100;
        return index == 0 ? 0.0 : sortedList.get(index - 1);
    }

    private static List<Double> sortedDoubleList(List<Number> numberList) {
        return JMStream.buildDoubleStream(numberList).sorted().boxed().collect(Collectors.toList());
    }

    private static int adjustTargetPercentile(int targetPercentile) {
        return targetPercentile < 0 ? 0 : (targetPercentile > 100 ? 100 : targetPercentile);
    }

    public static <N extends Number> Number min(List<N> numberList) {
        return JMCollections.isNullOrEmpty(numberList) ? 0.0 : (numberList.get(0) instanceof Integer ? (double)numberList.stream().mapToInt(Number::intValue).min().orElse(0) : (numberList.get(0) instanceof Long ? (double)numberList.stream().mapToLong(Number::longValue).min().orElse(0L) : numberList.stream().mapToDouble(Number::doubleValue).min().orElse(0.0)));
    }

    public static <N extends Number> Number max(List<N> numberList) {
        return JMCollections.isNullOrEmpty(numberList) ? 0.0 : (numberList.get(0) instanceof Integer ? (double)numberList.stream().mapToInt(Number::intValue).max().orElse(0) : (numberList.get(0) instanceof Long ? (double)numberList.stream().mapToLong(Number::longValue).max().orElse(0L) : numberList.stream().mapToDouble(Number::doubleValue).max().orElse(0.0)));
    }

    public static Number count(List<?> numberList) {
        return numberList.size();
    }

    public static <N extends Number> Number sum(List<N> numberList) {
        return JMCollections.isNullOrEmpty(numberList) ? 0.0 : (numberList.get(0) instanceof Integer ? (double)numberList.stream().mapToInt(Number::intValue).sum() : (numberList.get(0) instanceof Long ? (double)numberList.stream().mapToLong(Number::longValue).sum() : numberList.stream().mapToDouble(Number::doubleValue).sum()));
    }

    public static <N extends Number> Number average(List<N> numberList) {
        return JMCollections.isNullOrEmpty(numberList) ? 0.0 : (numberList.get(0) instanceof Integer ? numberList.stream().mapToInt(Number::intValue).average().orElse(0.0) : (numberList.get(0) instanceof Long ? numberList.stream().mapToLong(Number::longValue).average().orElse(0.0) : numberList.stream().mapToDouble(Number::doubleValue).average().orElse(0.0)));
    }

    public static int calPercent(Number target, Number total) {
        return (int)JMStats.calPercentPrecisely(target, total);
    }

    public static double calPercentPrecisely(Number target, Number total) {
        double totalD;
        double targetD = target.doubleValue();
        return targetD == (totalD = total.doubleValue()) ? 100.0 : targetD / totalD * 100.0;
    }

    public static String calPercent(Number target, Number total, int digit) {
        return JMString.roundedNumberFormat(JMStats.calPercentPrecisely(target, total), digit);
    }

    public static double roundWithDecimalPlace(double doubleNumber, int decimalPlace) {
        double pow = JMStats.pow(10, decimalPlace);
        return (double)Math.round(doubleNumber * pow) / pow;
    }

    public static double roundWithPlace(double doubleNumber, int place) {
        double pow = JMStats.pow(10, place);
        return (double)Math.round(doubleNumber / pow) * pow;
    }

    public static double pow(Number baseNumber, int exponent) {
        return exponent < 1 ? 1.0 : (exponent > 1 ? baseNumber.doubleValue() * JMStats.pow(baseNumber, exponent - 1) : baseNumber.doubleValue());
    }

    public static long roundWithPlace(long longNumber, int place) {
        return (long)JMStats.roundWithPlace((double)longNumber, place);
    }

    public static double calStandardDeviation(List<? extends Number> numberList) {
        return Math.sqrt(JMStats.calVariance(numberList));
    }

    public static double calPopulationStandardDeviation(List<? extends Number> numberList) {
        return Math.sqrt(JMStats.calPopulationVariance(numberList));
    }

    public static double calVariance(List<? extends Number> numberList) {
        return JMStats.calVariance(numberList, numberList.size() - 1);
    }

    public static double calPopulationVariance(List<? extends Number> numberList) {
        return JMStats.calVariance(numberList, numberList.size());
    }

    private static double calVariance(List<? extends Number> numberList, int count) {
        return numberList.size() == 1 ? 0.0 : JMStats.calSampleMinusMeanSumOfSquares(numberList, JMStream.buildDoubleStream(numberList).summaryStatistics().getAverage()) / (double)count;
    }

    private static double calSampleMinusMeanSumOfSquares(List<? extends Number> numberList, double average) {
        return JMStats.calSumOfSquares(JMStream.buildDoubleStream(numberList).map(d -> d - average));
    }

    public static double calSumOfSquares(List<? extends Number> numberList) {
        return JMStats.calSumOfSquares(numberList.stream().mapToDouble(Number::doubleValue));
    }

    public static double calSumOfSquares(DoubleStream doubleStream) {
        return doubleStream.map(d -> d * d).sum();
    }

    public static double calPairwiseVariance(long count1, double sum1, double variance1, long count2, double sum2, double variance2) {
        return (variance1 * (double)(count1 - 1L) + variance2 * (double)(count2 - 1L) + JMStats.pow(sum2 / (double)count2 - sum1 / (double)count1, 2) * (double)count1 * (double)count2 / (double)(count1 + count2)) / (double)(count1 + count2 - 1L);
    }
}

