/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.stats.collector;

import java.util.List;
import java.util.Map;
import kr.jm.utils.helper.JMString;
import kr.jm.utils.stats.collector.NumberItemCollector;
import kr.jm.utils.stats.collector.WordItemCollector;

public class WordNumberCollector {
    private String collectorId;
    private long timestamp;
    private Map<String, Object> metaMap;
    private WordItemCollector wordCollector;
    private NumberItemCollector numberCollector;

    public WordNumberCollector(String collectorId) {
        this(collectorId, System.currentTimeMillis());
    }

    public WordNumberCollector(String collectorId, long timestamp) {
        this(collectorId, timestamp, null);
    }

    public WordNumberCollector(String collectorId, long timestamp, Map<String, Object> metaMap) {
        this.collectorId = collectorId;
        this.timestamp = timestamp;
        this.wordCollector = new WordItemCollector();
        this.numberCollector = new NumberItemCollector();
        this.metaMap = metaMap;
    }

    private WordNumberCollector() {
    }

    public String getCollectorId() {
        return this.collectorId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, Object> getMetaMap() {
        return this.metaMap;
    }

    public WordNumberCollector addWord(String key, String word) {
        this.wordCollector.add(key, word);
        return this;
    }

    public WordNumberCollector addWordList(String key, List<String> wordList) {
        this.wordCollector.addAll(key, wordList);
        return this;
    }

    public Map<String, Map<String, Long>> buildWordCountMetricsMap() {
        return this.wordCollector.extractCollectingMap();
    }

    public WordNumberCollector addNumber(String key, Number number) {
        this.numberCollector.add(key, number);
        return this;
    }

    public WordNumberCollector addNumberList(String key, List<Number> numberList) {
        this.numberCollector.addAll(key, numberList);
        return this;
    }

    public Map<String, Map<String, Number>> buildNumberStatsMetricsMap() {
        return this.numberCollector.extractCollectingMap();
    }

    public WordNumberCollector addData(String key, String data) {
        if (JMString.isNumber(data)) {
            this.addNumber(key, Double.valueOf(data));
        } else {
            this.addWord(key, data);
        }
        return this;
    }

    public WordNumberCollector merge(WordNumberCollector wordNumberCollector) {
        this.wordCollector.merge(wordNumberCollector.wordCollector);
        this.numberCollector.merge(wordNumberCollector.numberCollector);
        return this;
    }

    public WordNumberCollector mergeAll(List<WordNumberCollector> wordNumberCollectorList) {
        for (WordNumberCollector wordNumberCollector : wordNumberCollectorList) {
            this.merge(wordNumberCollector);
        }
        return this;
    }

    public WordItemCollector getWordCollector() {
        return this.wordCollector;
    }

    public NumberItemCollector getNumberCollector() {
        return this.numberCollector;
    }

    public String toString() {
        return "WordNumberCollector(collectorId=" + this.getCollectorId() + ", timestamp=" + this.getTimestamp() + ", metaMap=" + this.getMetaMap() + ", wordCollector=" + this.getWordCollector() + ", numberCollector=" + this.getNumberCollector() + ")";
    }
}

