/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.kwonnam.spymemcached.extratranscoders.fst;

import kr.pe.kwonnam.spymemcached.extratranscoders.fst.FSTConfigurationFactory;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.Transcoder;
import org.nustaq.serialization.FSTConfiguration;

public class FSTTranscoder<T>
implements Transcoder<T> {
    public static final FSTConfigurationFactory DEFAULT_FSTCONFIGURATION_FACTORY = new FSTConfigurationFactory(){

        @Override
        public FSTConfiguration create() {
            return FSTConfiguration.createDefaultConfiguration();
        }
    };
    private final FSTConfigurationFactory fstConfigurationFactory;
    private final ThreadLocal<FSTConfiguration> fstConfigurationContainer;

    public FSTTranscoder() {
        this(DEFAULT_FSTCONFIGURATION_FACTORY);
    }

    public FSTTranscoder(final FSTConfigurationFactory fstConfigurationFactory) {
        this.fstConfigurationFactory = fstConfigurationFactory;
        this.fstConfigurationContainer = new ThreadLocal<FSTConfiguration>(){

            @Override
            protected FSTConfiguration initialValue() {
                return fstConfigurationFactory.create();
            }
        };
    }

    public FSTConfigurationFactory getFstConfigurationFactory() {
        return this.fstConfigurationFactory;
    }

    public CachedData encode(T object) {
        FSTConfiguration fstConfiguration = this.fstConfigurationContainer.get();
        byte[] serializedBytes = fstConfiguration.asByteArray(object);
        return new CachedData(0, serializedBytes, this.getMaxSize());
    }

    public T decode(CachedData cachedData) {
        FSTConfiguration fstConfiguration = this.fstConfigurationContainer.get();
        Object deserialized = fstConfiguration.asObject(cachedData.getData());
        return (T)deserialized;
    }

    public boolean asyncDecode(CachedData d) {
        return false;
    }

    public int getMaxSize() {
        return 0x1400000;
    }
}

