/*
 * Decompiled with CFR 0.152.
 */
package kr.summitsystems.springbukkit.core;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kr.summitsystems.springbukkit.core.SpringBukkitApplication;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b&\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H$J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\tJ\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0003H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0014\u0010\u0014\u001a\u00020\u00032\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkr/summitsystems/springbukkit/core/SpringBukkitPlugin;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/springframework/context/ApplicationContextInitializer;", "Lorg/springframework/context/ConfigurableApplicationContext;", "()V", "applicationContext", "getApplicationClass", "Ljava/lang/Class;", "initialize", "", "loadDefaultConfig", "loadResource", "filename", "", "onDisable", "onEnable", "registerPluginBean", "registerPropertiesPropertySource", "file", "registerYamlPropertySource", "runApplication", "applicationSource", "spring-bukkit-core"})
@SourceDebugExtension(value={"SMAP\nSpringBukkitPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBukkitPlugin.kt\nkr/summitsystems/springbukkit/core/SpringBukkitPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1855#2,2:90\n1#3:92\n*S KotlinDebug\n*F\n+ 1 SpringBukkitPlugin.kt\nkr/summitsystems/springbukkit/core/SpringBukkitPlugin\n*L\n71#1:90,2\n*E\n"})
public abstract class SpringBukkitPlugin
extends JavaPlugin
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    @Nullable
    private ConfigurableApplicationContext applicationContext;

    public final void onEnable() {
        this.loadDefaultConfig();
        if (AnnotationUtils.getAnnotation((AnnotatedElement)this.getApplicationClass(), SpringBukkitApplication.class) == null) {
            throw new IllegalStateException("Unable to initialize the unannotated application with @SpringBukkitApplication.");
        }
        this.applicationContext = this.runApplication(this.getApplicationClass());
    }

    public final void onDisable() {
        block0: {
            ConfigurableApplicationContext configurableApplicationContext = this.applicationContext;
            if (configurableApplicationContext == null) break block0;
            configurableApplicationContext.close();
        }
    }

    private final void loadDefaultConfig() {
        this.loadResource("application.yml");
        this.loadResource("config.yml");
        this.loadResource("application.properties");
    }

    private final void loadResource(String filename) {
        if (this.getResource(filename) != null && !new File(this.getDataFolder(), filename).exists()) {
            this.saveResource(filename, false);
        }
    }

    @NotNull
    protected abstract Class<?> getApplicationClass();

    private final ConfigurableApplicationContext runApplication(Class<?> applicationSource) {
        ClassLoader genuineClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        Class[] classArray = new Class[]{applicationSource};
        SpringApplicationBuilder springApplicationBuilder = new SpringApplicationBuilder(classArray);
        classArray = new ApplicationContextInitializer[]{this};
        Class[] it = classArray = springApplicationBuilder.web(WebApplicationType.NONE).bannerMode(Banner.Mode.OFF).initializers((ApplicationContextInitializer[])classArray).run(new String[0]);
        boolean bl = false;
        Thread.currentThread().setContextClassLoader(genuineClassLoader);
        Class[] classArray2 = classArray;
        Intrinsics.checkNotNullExpressionValue((Object)classArray2, (String)"SpringApplicationBuilder\u2026ClassLoader\n            }");
        return classArray2;
    }

    public void initialize(@NotNull ConfigurableApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.registerYamlPropertySource(applicationContext, "application.yml");
        this.registerYamlPropertySource(applicationContext, "config.yml");
        this.registerPropertiesPropertySource(applicationContext, "application.properties");
        this.registerPluginBean(applicationContext);
    }

    private final void registerYamlPropertySource(ConfigurableApplicationContext applicationContext, String file) {
        File configFile = new File(this.getDataFolder().getAbsolutePath() + "/" + file);
        if (configFile.exists()) {
            FileSystemResource resource = new FileSystemResource(configFile);
            YamlPropertySourceLoader yamlPropertySourceLoader = new YamlPropertySourceLoader();
            List yamlPropertySources = yamlPropertySourceLoader.load("spring-bukkit-" + file, (Resource)resource);
            Intrinsics.checkNotNullExpressionValue((Object)yamlPropertySources, (String)"yamlPropertySources");
            Iterable $this$forEach$iv = yamlPropertySources;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PropertySource yamlPropertySource = (PropertySource)element$iv;
                boolean bl = false;
                applicationContext.getEnvironment().getPropertySources().addLast(yamlPropertySource);
            }
        }
    }

    private final void registerPropertiesPropertySource(ConfigurableApplicationContext applicationContext, String file) {
        File configFile = new File(this.getDataFolder().getAbsolutePath() + "/" + file);
        if (configFile.exists()) {
            Properties properties;
            Properties properties2 = properties = new Properties();
            boolean bl = false;
            properties2.load(new FileInputStream(configFile));
            Properties properties3 = properties;
            PropertiesPropertySource propertySource = new PropertiesPropertySource("spring-bukkit-" + file, properties3);
            applicationContext.getEnvironment().getPropertySources().addLast((PropertySource)propertySource);
        }
    }

    private final void registerPluginBean(ConfigurableApplicationContext applicationContext) {
        applicationContext.getBeanFactory().registerSingleton("plugin", (Object)this);
    }
}

