/*
 * Decompiled with CFR 0.152.
 */
package kr.summitsystems.springbukkit.core.checker.annotation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kr.summitsystems.springbukkit.core.checker.ThreadCheckFailureException;
import kr.summitsystems.springbukkit.core.checker.annotation.EnsuresAsyncThread;
import kr.summitsystems.springbukkit.core.checker.annotation.EnsuresMainThread;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.bukkit.Server;
import org.jetbrains.annotations.NotNull;

@Aspect
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkr/summitsystems/springbukkit/core/checker/annotation/ThreadCheckerAdvisor;", "", "server", "Lorg/bukkit/Server;", "(Lorg/bukkit/Server;)V", "beforeEnsuresAsyncThread", "", "joinPoint", "Lorg/aspectj/lang/JoinPoint;", "ensuresAsyncThread", "Lkr/summitsystems/springbukkit/core/checker/annotation/EnsuresAsyncThread;", "beforeEnsuresMainThread", "ensuresMainThread", "Lkr/summitsystems/springbukkit/core/checker/annotation/EnsuresMainThread;", "ensuresAsyncThreadPointcut", "ensuresMainThreadPointcut", "spring-bukkit-core"})
public final class ThreadCheckerAdvisor {
    @NotNull
    private final Server server;

    public ThreadCheckerAdvisor(@NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
    }

    @Pointcut(value="@annotation(ensuresMainThread)")
    public final void ensuresMainThreadPointcut(@NotNull EnsuresMainThread ensuresMainThread) {
        Intrinsics.checkNotNullParameter((Object)ensuresMainThread, (String)"ensuresMainThread");
    }

    @Pointcut(value="@annotation(ensuresAsyncThread)")
    public final void ensuresAsyncThreadPointcut(@NotNull EnsuresAsyncThread ensuresAsyncThread) {
        Intrinsics.checkNotNullParameter((Object)ensuresAsyncThread, (String)"ensuresAsyncThread");
    }

    @Before(value="ensuresMainThreadPointcut(ensuresMainThread)")
    public final void beforeEnsuresMainThread(@NotNull JoinPoint joinPoint, @NotNull EnsuresMainThread ensuresMainThread) {
        Intrinsics.checkNotNullParameter((Object)joinPoint, (String)"joinPoint");
        Intrinsics.checkNotNullParameter((Object)ensuresMainThread, (String)"ensuresMainThread");
        if (!this.server.isPrimaryThread()) {
            String string = joinPoint.getSignature().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"joinPoint.signature.name");
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread()");
            throw new ThreadCheckFailureException.MainThread(string, thread);
        }
    }

    @Before(value="ensuresAsyncThreadPointcut(ensuresAsyncThread)")
    public final void beforeEnsuresAsyncThread(@NotNull JoinPoint joinPoint, @NotNull EnsuresAsyncThread ensuresAsyncThread) {
        Intrinsics.checkNotNullParameter((Object)joinPoint, (String)"joinPoint");
        Intrinsics.checkNotNullParameter((Object)ensuresAsyncThread, (String)"ensuresAsyncThread");
        if (this.server.isPrimaryThread()) {
            String string = joinPoint.getSignature().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"joinPoint.signature.name");
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread()");
            throw new ThreadCheckFailureException.AsyncThread(string, thread);
        }
    }
}

