/*
 * Decompiled with CFR 0.152.
 */
package kr.summitsystems.springbukkit.core.listener;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kr.summitsystems.springbukkit.core.listener.BukkitListenerRegistrar;
import kr.summitsystems.springbukkit.core.listener.EventExecutorFactory;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.SimplePluginManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002J4\u0010\u0016\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkr/summitsystems/springbukkit/core/listener/BukkitListenerRegistrarImpl;", "Lkr/summitsystems/springbukkit/core/listener/BukkitListenerRegistrar;", "plugin", "Lorg/bukkit/plugin/Plugin;", "pluginManager", "Lorg/bukkit/plugin/PluginManager;", "eventExecutorFactory", "Lkr/summitsystems/springbukkit/core/listener/EventExecutorFactory;", "(Lorg/bukkit/plugin/Plugin;Lorg/bukkit/plugin/PluginManager;Lkr/summitsystems/springbukkit/core/listener/EventExecutorFactory;)V", "bakeListener", "Lorg/bukkit/plugin/RegisteredListener;", "executor", "Lorg/bukkit/plugin/EventExecutor;", "priority", "Lorg/bukkit/event/EventPriority;", "ignoreCancelled", "", "registerBakedListener", "", "eventClass", "Ljava/lang/Class;", "registeredListener", "registerListener", "instance", "", "method", "Ljava/lang/reflect/Method;", "eventPriority", "spring-bukkit-core"})
public final class BukkitListenerRegistrarImpl
implements BukkitListenerRegistrar {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final EventExecutorFactory eventExecutorFactory;

    public BukkitListenerRegistrarImpl(@NotNull Plugin plugin, @NotNull PluginManager pluginManager, @NotNull EventExecutorFactory eventExecutorFactory) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)eventExecutorFactory, (String)"eventExecutorFactory");
        this.plugin = plugin;
        this.pluginManager = pluginManager;
        this.eventExecutorFactory = eventExecutorFactory;
    }

    @Override
    public void registerListener(@NotNull Class<?> eventClass, @NotNull Object instance, @NotNull Method method, @NotNull EventPriority eventPriority, boolean ignoreCancelled) {
        Intrinsics.checkNotNullParameter(eventClass, (String)"eventClass");
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)eventPriority, (String)"eventPriority");
        if (eventClass.isAssignableFrom(Event.class)) {
            throw new IllegalStateException("first parameter of event handler must be event. (method: " + method.getName() + ", parameter1: " + eventClass.getSimpleName() + ")");
        }
        EventExecutor executor = this.eventExecutorFactory.create(eventClass, instance, method);
        RegisteredListener listener = this.bakeListener(executor, eventPriority, this.plugin, ignoreCancelled);
        this.registerBakedListener(eventClass, listener);
    }

    private final RegisteredListener bakeListener(EventExecutor executor, EventPriority priority, Plugin plugin, boolean ignoreCancelled) {
        return new RegisteredListener(new Listener(){}, executor, priority, plugin, ignoreCancelled);
    }

    private final void registerBakedListener(Class<?> eventClass, RegisteredListener registeredListener) {
        Class[] classArray = new Class[]{Class.class};
        Method eventListeners = SimplePluginManager.class.getDeclaredMethod("getEventListeners", classArray);
        eventListeners.setAccessible(true);
        Object[] objectArray = new Object[]{eventClass};
        Object object = eventListeners.invoke((Object)this.pluginManager, objectArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bukkit.event.HandlerList");
        HandlerList handlerList = (HandlerList)object;
        handlerList.register(registeredListener);
    }
}

