/*
 * Decompiled with CFR 0.152.
 */
package kr.summitsystems.springbukkit.core.support;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.core.convert.converter.Converter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0002\u0005\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0007"}, d2={"Lkr/summitsystems/springbukkit/core/support/SpringBukkitConversionService;", "Lorg/springframework/boot/convert/ApplicationConversionService;", "()V", "addPropertyConverters", "", "ConfigurationSectionToMapConverter", "ConfigurationSectionToPropertiesConverter", "spring-bukkit-core"})
public class SpringBukkitConversionService
extends ApplicationConversionService {
    public SpringBukkitConversionService() {
        this.addPropertyConverters();
    }

    private final void addPropertyConverters() {
        this.addConverter(new ConfigurationSectionToMapConverter());
        this.addConverter(new ConfigurationSectionToPropertiesConverter());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0004\b\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lkr/summitsystems/springbukkit/core/support/SpringBukkitConversionService$ConfigurationSectionToMapConverter;", "Lorg/springframework/core/convert/converter/Converter;", "Lorg/bukkit/configuration/ConfigurationSection;", "", "()V", "convert", "source", "spring-bukkit-core"})
    private static final class ConfigurationSectionToMapConverter
    implements Converter<ConfigurationSection, Map<?, ?>> {
        @NotNull
        public Map<?, ?> convert(@NotNull ConfigurationSection source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Map map = source.getValues(true);
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"source.getValues(true)");
            return map;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lkr/summitsystems/springbukkit/core/support/SpringBukkitConversionService$ConfigurationSectionToPropertiesConverter;", "Lorg/springframework/core/convert/converter/Converter;", "Lorg/bukkit/configuration/ConfigurationSection;", "Ljava/util/Properties;", "()V", "convert", "source", "spring-bukkit-core"})
    private static final class ConfigurationSectionToPropertiesConverter
    implements Converter<ConfigurationSection, Properties> {
        @NotNull
        public Properties convert(@NotNull ConfigurationSection source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new Properties(source){
                final /* synthetic */ ConfigurationSection $source;
                {
                    this.$source = $source;
                }

                @NotNull
                public Collection<Object> getValues() {
                    return this.$source.getValues(true).values();
                }

                @NotNull
                public Set<Object> getKeys() {
                    Set set = this.$source.getKeys(true);
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"source.getKeys(true)");
                    return CollectionsKt.toMutableSet((Iterable)set);
                }
            };
        }
    }
}

