/*
 * Decompiled with CFR 0.152.
 */
package kr.summitsystems.springbukkit.core.support.config;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kr.summitsystems.springbukkit.core.support.SpringBukkitConversionService;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;

@Configuration
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\t\u001a\u00020\u0006H\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0017\u00a8\u0006\u0012"}, d2={"Lkr/summitsystems/springbukkit/core/support/config/BukkitConfiguration;", "", "()V", "bukkitPluginManager", "Lorg/bukkit/plugin/PluginManager;", "server", "Lorg/bukkit/Server;", "bukkitScheduler", "Lorg/bukkit/scheduler/BukkitScheduler;", "bukkitServer", "bukkitServicesManager", "Lorg/bukkit/plugin/ServicesManager;", "conversionService", "Lorg/springframework/core/convert/ConversionService;", "plugin", "Lorg/bukkit/plugin/Plugin;", "pluginDescriptionFile", "Lorg/bukkit/plugin/PluginDescriptionFile;", "spring-bukkit-core"})
public class BukkitConfiguration {
    @Bean
    @NotNull
    public Server bukkitServer() {
        Server server = Bukkit.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"getServer()");
        return server;
    }

    @Bean
    @NotNull
    public PluginManager bukkitPluginManager(@NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        PluginManager pluginManager = server.getPluginManager();
        Intrinsics.checkNotNullExpressionValue((Object)pluginManager, (String)"server.pluginManager");
        return pluginManager;
    }

    @Bean
    @NotNull
    public ServicesManager bukkitServicesManager(@NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        ServicesManager servicesManager = server.getServicesManager();
        Intrinsics.checkNotNullExpressionValue((Object)servicesManager, (String)"server.servicesManager");
        return servicesManager;
    }

    @Bean
    @NotNull
    public BukkitScheduler bukkitScheduler(@NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        BukkitScheduler bukkitScheduler = server.getScheduler();
        Intrinsics.checkNotNullExpressionValue((Object)bukkitScheduler, (String)"server.scheduler");
        return bukkitScheduler;
    }

    @Bean
    @NotNull
    public PluginDescriptionFile pluginDescriptionFile(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        PluginDescriptionFile pluginDescriptionFile = plugin.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptionFile, (String)"plugin.description");
        return pluginDescriptionFile;
    }

    @ConditionalOnMissingBean(value={Plugin.class})
    @Bean
    @NotNull
    public Plugin plugin() {
        throw new NotImplementedError(null, 1, null);
    }

    @Bean
    @NotNull
    public ConversionService conversionService() {
        return (ConversionService)new SpringBukkitConversionService();
    }
}

