/*
 * Decompiled with CFR 0.152.
 */
package kr.summitsystems.springbukkit.core.support.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u000f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkr/summitsystems/springbukkit/core/support/serializer/BukkitObjectSerializer;", "T", "Lorg/bukkit/configuration/serialization/ConfigurationSerializable;", "Lorg/springframework/core/serializer/Serializer;", "Lorg/springframework/core/serializer/Deserializer;", "deflate", "", "(Z)V", "deflateByteArray", "", "byteArray", "deserialize", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)Lorg/bukkit/configuration/serialization/ConfigurationSerializable;", "deserializeFromByteArray", "([B)Lorg/bukkit/configuration/serialization/ConfigurationSerializable;", "inflateByteArray", "serialize", "", "configurationSerializable", "outputStream", "Ljava/io/OutputStream;", "(Lorg/bukkit/configuration/serialization/ConfigurationSerializable;Ljava/io/OutputStream;)V", "serializeToByteArray", "(Lorg/bukkit/configuration/serialization/ConfigurationSerializable;)[B", "spring-bukkit-core"})
public class BukkitObjectSerializer<T extends ConfigurationSerializable>
implements Serializer<T>,
Deserializer<T> {
    private final boolean deflate;

    public BukkitObjectSerializer(boolean deflate) {
        this.deflate = deflate;
    }

    public /* synthetic */ BukkitObjectSerializer(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(@NotNull T configurationSerializable, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter(configurationSerializable, (String)"configurationSerializable");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Closeable closeable = (Closeable)new BukkitObjectOutputStream(outputStream);
        Throwable throwable = null;
        try {
            BukkitObjectOutputStream bukkitObjectOutputStream = (BukkitObjectOutputStream)closeable;
            boolean bl = false;
            bukkitObjectOutputStream.writeObject(configurationSerializable);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public T deserialize(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Closeable closeable = (Closeable)new BukkitObjectInputStream(inputStream);
        Throwable throwable = null;
        try {
            BukkitObjectInputStream bukkitObjectInputStream = (BukkitObjectInputStream)closeable;
            boolean bl = false;
            Object object = bukkitObjectInputStream.readObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of kr.summitsystems.springbukkit.core.support.serializer.BukkitObjectSerializer.deserialize$lambda$1");
            ConfigurationSerializable configurationSerializable = (ConfigurationSerializable)object;
            return (T)configurationSerializable;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] serializeToByteArray(@NotNull T configurationSerializable) {
        Intrinsics.checkNotNullParameter(configurationSerializable, (String)"configurationSerializable");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            this.serialize(configurationSerializable, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
            byte[] byArray2 = this.deflateByteArray(byArray);
            return byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public T deserializeFromByteArray(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        byte[] buf = this.deflate ? this.inflateByteArray(byteArray) : byteArray;
        Closeable closeable = new ByteArrayInputStream(buf);
        Throwable throwable = null;
        try {
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)closeable;
            boolean bl = false;
            T t = this.deserialize(byteArrayInputStream);
            return t;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] deflateByteArray(byte[] byteArray) {
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DeflaterOutputStream(it);
            Throwable throwable2 = null;
            try {
                DeflaterOutputStream outputStream = (DeflaterOutputStream)closeable2;
                boolean bl2 = false;
                outputStream.write(byteArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byte[] byArray = it.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"it.toByteArray()");
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] inflateByteArray(byte[] byteArray) {
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new InflaterOutputStream(it);
            Throwable throwable2 = null;
            try {
                InflaterOutputStream inputStream = (InflaterOutputStream)closeable2;
                boolean bl2 = false;
                inputStream.write(byteArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byte[] byArray = it.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"it.toByteArray()");
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public BukkitObjectSerializer() {
        this(false, 1, null);
    }
}

