/*
 * Decompiled with CFR 0.152.
 */
package kr.summitsystems.springbukkit.core.util;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.md_5.bungee.api.ChatColor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkr/summitsystems/springbukkit/core/util/BukkitColorUtils;", "", "()V", "COLOR_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "GRADIENT_PATTERN", "applyGradient", "", "text", "startColor", "Lnet/md_5/bungee/api/ChatColor;", "endColor", "interpolate", "", "color1", "color2", "ratio", "", "interpolateColor", "parse", "parseColor", "parseGradient", "spring-bukkit-core"})
public final class BukkitColorUtils {
    @NotNull
    public static final BukkitColorUtils INSTANCE = new BukkitColorUtils();
    @NotNull
    private static final Pattern GRADIENT_PATTERN;
    private static final Pattern COLOR_PATTERN;

    private BukkitColorUtils() {
    }

    @NotNull
    public final String parse(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String result = text;
        result = this.parseColor(result);
        result = this.parseGradient(result);
        return result;
    }

    private final String parseColor(String text) {
        Matcher matcher = COLOR_PATTERN.matcher(text);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"COLOR_PATTERN.matcher(text)");
        Matcher matcher2 = matcher;
        StringBuffer result = new StringBuffer();
        while (matcher2.find()) {
            String colorCode = matcher2.group(1);
            ChatColor color = ChatColor.of((String)("#" + colorCode));
            matcher2.appendReplacement(result, color.toString());
        }
        matcher2.appendTail(result);
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final String parseGradient(String text) {
        Matcher matcher = GRADIENT_PATTERN.matcher(text);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"GRADIENT_PATTERN.matcher(text)");
        Matcher matcher2 = matcher;
        StringBuffer result = new StringBuffer();
        while (matcher2.find()) {
            String content;
            String endColor;
            String startColor;
            Intrinsics.checkNotNullExpressionValue((Object)matcher2.group(1), (String)"matcher.group(1)");
            Intrinsics.checkNotNullExpressionValue((Object)matcher2.group(2), (String)"matcher.group(2)");
            Intrinsics.checkNotNullExpressionValue((Object)matcher2.group(3), (String)"matcher.group(3)");
            ChatColor startChatColor = ChatColor.of((String)startColor);
            ChatColor endChatColor = ChatColor.of((String)endColor);
            Intrinsics.checkNotNullExpressionValue((Object)startChatColor, (String)"startChatColor");
            Intrinsics.checkNotNullExpressionValue((Object)endChatColor, (String)"endChatColor");
            String gradientText = this.applyGradient(content, startChatColor, endChatColor);
            matcher2.appendReplacement(result, gradientText);
        }
        matcher2.appendTail(result);
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final String applyGradient(String text, ChatColor startColor, ChatColor endColor) {
        StringBuilder result = new StringBuilder();
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char currentChar = text.charAt(i);
            ChatColor gradientColor = this.interpolateColor(startColor, endColor, (float)i / (float)text.length());
            result.append(gradientColor).append(currentChar);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final ChatColor interpolateColor(ChatColor startColor, ChatColor endColor, float ratio) {
        int startRGB = startColor.getColor().getRGB();
        int endRGB = endColor.getColor().getRGB();
        int interpolatedRGB = this.interpolate(startRGB, endRGB, ratio);
        ChatColor chatColor = ChatColor.of((Color)new Color(interpolatedRGB));
        Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"of(Color(interpolatedRGB))");
        return chatColor;
    }

    private final int interpolate(int color1, int color2, float ratio) {
        int red = (int)((float)BukkitColorUtils.interpolate$getRed(color1) * (1.0f - ratio) + (float)BukkitColorUtils.interpolate$getRed(color2) * ratio);
        int green = (int)((float)BukkitColorUtils.interpolate$getGreen(color1) * (1.0f - ratio) + (float)BukkitColorUtils.interpolate$getGreen(color2) * ratio);
        int blue = (int)((float)BukkitColorUtils.interpolate$getBlue(color1) * (1.0f - ratio) + (float)BukkitColorUtils.interpolate$getBlue(color2) * ratio);
        return (red << 16) + (green << 8) + blue;
    }

    private static final int interpolate$getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    private static final int interpolate$getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    private static final int interpolate$getBlue(int rgb) {
        return rgb & 0xFF;
    }

    static {
        Pattern pattern = Pattern.compile("<gradient:(#[a-fA-F0-9]{6}):(#[a-fA-F0-9]{6})>(.*?)</gradient>");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"<gradient:(#[a-\u20269]{6})>(.*?)</gradient>\")");
        GRADIENT_PATTERN = pattern;
        COLOR_PATTERN = Pattern.compile("<#([a-fA-F0-9]{6})>");
    }
}

