/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.db;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFContext {
    private final EntityManagerFactory factory;
    private final ThreadLocal<EntityManager> tls = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(EMFContext.class);

    public EMFContext(EntityManagerFactory factory) {
        this.factory = factory;
    }

    public EntityManager getOrCreateEntityManager() {
        EntityManager entityManager = this.tls.get();
        if (entityManager == null) {
            entityManager = this.getFactory().createEntityManager();
            logger.debug("Created new entity manager ({}) for thread ({})", (Object)entityManager.hashCode(), (Object)Thread.currentThread().getName());
            this.tls.set(entityManager);
        } else {
            logger.debug("Retrieved entity manager ({}) for thread ({})", (Object)entityManager.hashCode(), (Object)Thread.currentThread().getName());
        }
        return entityManager;
    }

    public EntityManagerFactory getFactory() {
        return this.factory;
    }
}

