/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.db;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import li.rudin.core.db.EMFContext;

@ApplicationScoped
public class EntityManagerProducer {
    private final Map<String, EMFContext> contextMap = new HashMap<String, EMFContext>();

    @PreDestroy
    public void destroy() {
        for (EMFContext ctx : this.contextMap.values()) {
            ctx.getFactory().close();
        }
    }

    @Dependent
    @Produces
    public EntityManager produceEntityManager(InjectionPoint p) {
        PersistenceContext context = (PersistenceContext)p.getAnnotated().getAnnotation(PersistenceContext.class);
        String unitName = context.unitName();
        return this.getOrCreateEntityManager(unitName);
    }

    public EntityManager getOrCreateEntityManager(String unitName) {
        EMFContext ctx = this.getContextMap().get(unitName);
        if (ctx == null) {
            ctx = new EMFContext(Persistence.createEntityManagerFactory((String)unitName));
            this.getContextMap().put(unitName, ctx);
        }
        return ctx.getOrCreateEntityManager();
    }

    public void disposeEntityManager(@Disposes EntityManager em) {
        em.close();
    }

    public Map<String, EMFContext> getContextMap() {
        return this.contextMap;
    }
}

