/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.core.db.transactional;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityTransaction;
import li.rudin.core.db.EMFContext;
import li.rudin.core.db.EntityManagerProducer;
import li.rudin.core.db.transactional.Transactional;
import org.slf4j.Logger;

@Transactional
@Interceptor
public class TransactionalInterceptor
implements Serializable {
    private static final long serialVersionUID = -1805712126991388844L;
    @Inject
    EntityManagerProducer emProducer;
    @Inject
    Logger logger;

    @AroundInvoke
    public Object manageTransaction(InvocationContext ctx) throws Exception {
        Map<String, EMFContext> contextMap = this.emProducer.getContextMap();
        ArrayList<EntityTransaction> transactions = new ArrayList<EntityTransaction>();
        for (EMFContext context : contextMap.values()) {
            transactions.add(context.getOrCreateEntityManager().getTransaction());
        }
        try {
            this.logger.debug("Beginning {} transaction(s) in thread: {} for method: {}", new Object[]{transactions.size(), Thread.currentThread().getName(), ctx.getTarget().getClass().getName() + "." + ctx.getMethod().getName()});
            for (EntityTransaction tx : transactions) {
                tx.begin();
            }
            Object result = ctx.proceed();
            this.logger.debug("Commiting {} transaction(s) in thread: {}", (Object)transactions.size(), (Object)Thread.currentThread().getName());
            for (EntityTransaction tx : transactions) {
                tx.commit();
            }
            return result;
        }
        catch (Exception e) {
            this.logger.debug("Rolling back {} transaction(s) in thread: {}", (Object)transactions.size(), (Object)Thread.currentThread().getName());
            this.logger.error("manageTransaction", (Throwable)e);
            for (EntityTransaction tx : transactions) {
                tx.rollback();
            }
            throw e;
        }
    }
}

