/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.api;

import java.text.MessageFormat;

public enum ComponentState {
    UNDEFINED,
    SETUP,
    INITIALIZED,
    STARTED,
    STOPPED,
    DESTROYED;


    public ComponentState validateStateChange(ComponentState newState) {
        if (this == newState) {
            return this;
        }
        switch (this) {
            case UNDEFINED: {
                if (newState == SETUP || newState == STOPPED) break;
                throw this.getIllegalStateEx(newState);
            }
            case SETUP: {
                if (newState == INITIALIZED || newState == STOPPED || newState == DESTROYED) break;
                throw this.getIllegalStateEx(newState);
            }
            case INITIALIZED: {
                if (newState == STARTED || newState == STOPPED || newState == DESTROYED) break;
                throw this.getIllegalStateEx(newState);
            }
            case STARTED: {
                if (newState == STOPPED) break;
                throw this.getIllegalStateEx(newState);
            }
            case STOPPED: {
                if (newState == STARTED || newState == DESTROYED) break;
                throw this.getIllegalStateEx(newState);
            }
            case DESTROYED: {
                throw this.getIllegalStateEx(newState);
            }
            default: {
                throw this.getIllegalStateEx(newState);
            }
        }
        return newState;
    }

    private IllegalStateException getIllegalStateEx(ComponentState newState) {
        String msg = "Moving from state {0} to state {1} is not allowed!";
        msg = MessageFormat.format(msg, new Object[]{this, newState});
        throw new IllegalStateException(msg);
    }
}

