/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Set;
import li.strolch.agent.api.AgentVersion;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.ComponentState;
import li.strolch.agent.api.ComponentVersion;
import li.strolch.agent.api.StrolchComponent;
import li.strolch.agent.api.StrolchVersion;
import li.strolch.agent.api.VersionQueryResult;
import li.strolch.agent.impl.ComponentContainerImpl;
import li.strolch.runtime.configuration.ConfigurationParser;
import li.strolch.runtime.configuration.RuntimeConfiguration;
import li.strolch.runtime.configuration.StrolchConfiguration;
import li.strolch.utils.helper.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrolchAgent {
    public static final String AGENT_VERSION_PROPERTIES = "/agentVersion.properties";
    private static final Logger logger = LoggerFactory.getLogger(StrolchAgent.class);
    private ComponentContainerImpl container;
    private StrolchConfiguration strolchConfiguration;
    private StrolchVersion appVersion;
    private VersionQueryResult versionQueryResult;

    public StrolchAgent(StrolchVersion appVersion) {
        this.appVersion = appVersion;
    }

    public StrolchConfiguration getStrolchConfiguration() {
        return this.strolchConfiguration;
    }

    public ComponentContainer getContainer() {
        return this.container;
    }

    public String getApplicationName() {
        return this.strolchConfiguration.getRuntimeConfiguration().getApplicationName();
    }

    public void initialize() {
        if (this.container == null) {
            throw new RuntimeException("Please call setup first!");
        }
        this.container.initialize(this.strolchConfiguration);
    }

    public void start() {
        if (this.container == null) {
            throw new RuntimeException("Please call setup first!");
        }
        this.container.start();
    }

    public void stop() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    public void destroy() {
        if (this.container != null) {
            this.container.destroy();
        }
        this.container = null;
    }

    void setup(String environment, File configPathF, File dataPathF, File tempPathF) {
        String msg = "[{0}] Setting up Strolch Container using the following paths:";
        logger.info(MessageFormat.format(msg, environment));
        logger.info(" - Config: " + configPathF.getAbsolutePath());
        logger.info(" - Data: " + dataPathF.getAbsolutePath());
        logger.info(" - Temp: " + tempPathF.getAbsolutePath());
        this.strolchConfiguration = ConfigurationParser.parseConfiguration(environment, configPathF, dataPathF, tempPathF);
        ComponentContainerImpl container = new ComponentContainerImpl(this);
        container.setup(this.strolchConfiguration);
        this.container = container;
        RuntimeConfiguration config = this.strolchConfiguration.getRuntimeConfiguration();
        logger.info(MessageFormat.format("Setup Agent {0}:{1}", config.getApplicationName(), config.getEnvironment()));
    }

    protected void assertContainerStarted() {
        if (this.container == null || this.container.getState() != ComponentState.STARTED) {
            String msg = "Container is not yet started!";
            throw new IllegalStateException(msg);
        }
    }

    public static synchronized String getUniqueId() {
        return StringHelper.getUniqueId();
    }

    public static synchronized Long getUniqueIdLong() {
        return StringHelper.getUniqueIdLong();
    }

    public VersionQueryResult getVersion() {
        if (this.versionQueryResult == null) {
            VersionQueryResult queryResult = new VersionQueryResult();
            queryResult.setAppVersion(this.appVersion);
            Properties properties = new Properties();
            try {
                InputStream stream = this.getClass().getResourceAsStream(AGENT_VERSION_PROPERTIES);
                Object object = null;
                try {
                    properties.load(stream);
                    AgentVersion agentVersion = new AgentVersion(this.getStrolchConfiguration().getRuntimeConfiguration().getApplicationName(), properties);
                    queryResult.setAgentVersion(agentVersion);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        if (object != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Failed to read version properties for agent: {0}", e.getMessage());
                queryResult.getErrors().add(msg);
                logger.error(msg, (Throwable)e);
            }
            Set<Class<?>> componentTypes = this.container.getComponentTypes();
            for (Class clazz : componentTypes) {
                StrolchComponent component = (StrolchComponent)this.container.getComponent(clazz);
                try {
                    ComponentVersion componentVersion = component.getVersion();
                    queryResult.add(componentVersion);
                }
                catch (Exception e) {
                    String msg = "Failed to read version properties for component {0} due to: {1}";
                    msg = MessageFormat.format(msg, component.getName(), e.getMessage());
                    queryResult.getErrors().add(msg);
                    logger.error(msg, (Throwable)e);
                }
            }
            this.versionQueryResult = queryResult;
        }
        return this.versionQueryResult;
    }
}

