/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.api;

import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Properties;
import li.strolch.agent.api.StrolchAgent;
import li.strolch.agent.api.StrolchVersion;
import li.strolch.runtime.configuration.StrolchConfigurationException;
import li.strolch.runtime.configuration.StrolchEnvironment;
import li.strolch.utils.dbc.DBC;
import li.strolch.utils.helper.FileHelper;
import li.strolch.utils.helper.StringHelper;
import li.strolch.utils.helper.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StrolchBootstrapper
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger(StrolchBootstrapper.class);
    public static final String APP_VERSION_PROPERTIES = "/appVersion.properties";
    private static final String SYS_PROP_USER_DIR = "user.dir";
    private static final String STROLCH_BOOTSTRAP = "StrolchBootstrap";
    private static final String ENV = "env";
    private static final String ID = "id";
    private static final String DEFAULT = "default";
    private static final String ENVIRONMENT = "environment";
    private static final String ROOT = "root";
    private static final String CONFIG = "config";
    private static final String DATA = "data";
    private static final String TEMP = "temp";
    public static final String FILE_BOOTSTRAP = "StrolchBootstrap.xml";
    public static final String PATH_CONFIG = "config";
    public static final String PATH_DATA = "data";
    public static final String PATH_TEMP = "temp";
    private String environment;
    private boolean defaultAllowed;
    private String environmentOverride;
    private boolean envFound;
    private boolean insideEnv;
    private StringBuilder textB;
    private String rootS;
    private String configS;
    private String dataS;
    private String tempS;
    private File configPathF;
    private File dataPathF;
    private File tempPathF;
    private StrolchVersion appVersion;

    public StrolchBootstrapper(StrolchVersion appVersion) {
        DBC.PRE.assertNotNull("appVersion must be set!", (Object)appVersion);
        this.appVersion = appVersion;
    }

    public StrolchBootstrapper(Class<?> appClass) {
        StrolchVersion appVersion;
        DBC.PRE.assertNotNull("appClass must be set!", appClass);
        Properties env = new Properties();
        try (InputStream in = appClass.getResourceAsStream(APP_VERSION_PROPERTIES);){
            env.load(in);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find resource /appVersion.properties on ClassLoader of class " + appClass);
        }
        this.appVersion = appVersion = new StrolchVersion(env);
    }

    public void setEnvironmentOverride(String environmentOverride) {
        this.environmentOverride = environmentOverride;
    }

    public StrolchAgent setupByUserDir(String environment) {
        DBC.PRE.assertNotEmpty("Environment must be set!", environment);
        this.environment = environment;
        File rootPathF = new File(System.getProperty(SYS_PROP_USER_DIR));
        this.configPathF = new File(rootPathF, "config");
        this.dataPathF = new File(rootPathF, "data");
        this.tempPathF = new File(rootPathF, "temp");
        return this.setup();
    }

    public StrolchAgent setupByRoot(String environment, File rootPath) {
        DBC.PRE.assertNotEmpty("Environment must be set!", environment);
        DBC.PRE.assertNotNull("rootPath must be set!", (Object)rootPath);
        this.environment = environment;
        this.configPathF = new File(rootPath, "config");
        this.dataPathF = new File(rootPath, "data");
        this.tempPathF = new File(rootPath, "temp");
        return this.setup();
    }

    public StrolchAgent setupByCopyingRoot(String environment, File rootSrcPath, File rootDstPath) {
        DBC.PRE.assertNotEmpty("Environment must be set!", environment);
        DBC.PRE.assertNotNull("rootPath must be set!", (Object)rootSrcPath);
        DBC.PRE.assertNotNull("rootPath must be set!", (Object)rootDstPath);
        this.environment = environment;
        if (!rootSrcPath.isDirectory() || !rootSrcPath.canRead()) {
            String msg = "[{0}] Root src path is not readable at {1}";
            msg = MessageFormat.format(msg, environment, rootSrcPath);
            throw new StrolchConfigurationException(msg);
        }
        File configPathF = new File(rootSrcPath, "config");
        File configurationFile = new File(configPathF, "StrolchConfiguration.xml");
        if (!configurationFile.isFile() || !configurationFile.canRead()) {
            String msg = "[{0}] Source Configuration file is not readable at {1}";
            msg = MessageFormat.format(msg, environment, configurationFile);
            throw new StrolchConfigurationException(msg);
        }
        if (rootDstPath.exists()) {
            if (!rootDstPath.isDirectory()) {
                String msg = "[{0}] Destination root exists and is not a directory at {1}";
                msg = MessageFormat.format(msg, environment, rootDstPath.getAbsolutePath());
                throw new StrolchConfigurationException(msg);
            }
            if (rootDstPath.list().length != 0) {
                String msg = "[{0}] Destination root exists and is not empty at {1}";
                msg = MessageFormat.format(msg, environment, rootDstPath.getAbsolutePath());
                throw new StrolchConfigurationException(msg);
            }
        } else if (!rootDstPath.mkdir()) {
            String msg = "[{0}] Destination root does not exist and could not be created. Either parent does not exist, or permission is denied at {1}";
            msg = MessageFormat.format(msg, environment, rootDstPath.getAbsolutePath());
            throw new StrolchConfigurationException(msg);
        }
        String msg = "[{0}] Copying source {1} to {2}";
        logger.info(MessageFormat.format(msg, environment, rootSrcPath.getAbsolutePath(), rootDstPath.getAbsolutePath()));
        if (!FileHelper.copy((File[])rootSrcPath.listFiles(), (File)rootDstPath, (boolean)true)) {
            msg = "[{0}] Failed to copy source files from {1} to {2}";
            msg = MessageFormat.format(msg, environment, rootSrcPath.getAbsolutePath(), rootDstPath.getAbsolutePath());
            throw new RuntimeException(msg);
        }
        this.configPathF = new File(rootDstPath, "config");
        this.dataPathF = new File(rootDstPath, "data");
        this.tempPathF = new File(rootDstPath, "temp");
        return this.setup();
    }

    public StrolchAgent setupByBoostrapFile(Class<?> clazz, File bootstrapFile) {
        DBC.PRE.assertNotNull("clazz must be set!", clazz);
        DBC.PRE.assertNotNull("bootstrapFile must be set!", (Object)bootstrapFile);
        this.environment = StrolchEnvironment.getEnvironmentFromResourceEnv(clazz);
        this.parseBoostrapFile(bootstrapFile);
        return this.setup();
    }

    public StrolchAgent setupByBoostrapFile(Class<?> clazz, InputStream bootstrapFile) {
        DBC.PRE.assertNotNull("clazz must be set!", clazz);
        DBC.PRE.assertNotNull("bootstrapFile must be set!", (Object)bootstrapFile);
        this.environment = StrolchEnvironment.getEnvironmentFromResourceEnv(clazz);
        this.parseBoostrapFile(bootstrapFile);
        return this.setup();
    }

    public StrolchAgent setupByBoostrapFile(String environment, File bootstrapFile) {
        DBC.PRE.assertNotEmpty("Environment must be set!", environment);
        DBC.PRE.assertNotNull("bootstrapFile must be set!", (Object)bootstrapFile);
        this.environment = environment;
        this.parseBoostrapFile(bootstrapFile);
        return this.setup();
    }

    public StrolchAgent setupByBoostrapFile(String environment, InputStream bootstrapFile) {
        DBC.PRE.assertNotEmpty("Environment must be set!", environment);
        DBC.PRE.assertNotNull("bootstrapFile must be set!", (Object)bootstrapFile);
        this.environment = environment;
        this.parseBoostrapFile(bootstrapFile);
        return this.setup();
    }

    private StrolchAgent setup() {
        String env;
        DBC.PRE.assertNotEmpty("Environment must be set!", this.environment);
        DBC.PRE.assertNotNull("configPathF must be set!", (Object)this.configPathF);
        DBC.PRE.assertNotNull("dataPathF must be set!", (Object)this.dataPathF);
        DBC.PRE.assertNotNull("tempPathF must be set!", (Object)this.tempPathF);
        if (!this.configPathF.isDirectory() || !this.configPathF.canRead()) {
            String msg = "[{0}] Config path is not readable at {1}";
            msg = MessageFormat.format(msg, this.environment, this.configPathF);
            throw new StrolchConfigurationException(msg);
        }
        File configurationFile = new File(this.configPathF, "StrolchConfiguration.xml");
        if (!configurationFile.isFile() || !configurationFile.canRead()) {
            String msg = "[{0}] Configuration file is not readable at {1}";
            msg = MessageFormat.format(msg, this.environment, configurationFile);
            throw new StrolchConfigurationException(msg);
        }
        if (!this.dataPathF.exists() && !this.dataPathF.mkdir()) {
            String msg = "[{0}] Could not create missing data path at {1}";
            msg = MessageFormat.format(msg, this.environment, this.dataPathF);
            throw new StrolchConfigurationException(msg);
        }
        if (!(this.dataPathF.isDirectory() && this.dataPathF.canRead() && this.dataPathF.canWrite())) {
            String msg = "[{0}] Data path is not a directory or readable or writeable at {1}";
            msg = MessageFormat.format(msg, this.environment, this.dataPathF);
            throw new StrolchConfigurationException(msg);
        }
        if (!this.tempPathF.exists() && !this.tempPathF.mkdir()) {
            String msg = "[{0}] Could not create missing temp path at {1}";
            msg = MessageFormat.format(msg, this.environment, this.tempPathF);
            throw new StrolchConfigurationException(msg);
        }
        if (!(this.tempPathF.isDirectory() && this.tempPathF.canRead() && this.tempPathF.canWrite())) {
            String msg = "[{0}] Temp path is not a directory or readable or writeable at {1}";
            msg = MessageFormat.format(msg, this.environment, this.tempPathF);
            throw new StrolchConfigurationException(msg);
        }
        if (StringHelper.isEmpty((String)this.environmentOverride)) {
            env = this.environment;
        } else {
            String msg = "[{0}] Environment override to ''{1}''";
            logger.info(MessageFormat.format(msg, this.environment, this.environmentOverride));
            env = this.environmentOverride;
        }
        StrolchAgent agent = new StrolchAgent(this.appVersion);
        agent.setup(env, this.configPathF, this.dataPathF, this.tempPathF);
        return agent;
    }

    private void parseBoostrapFile(File bootstrapFile) {
        XmlHelper.parseDocument((File)bootstrapFile, (DefaultHandler)this);
        if (!this.envFound) {
            throw new StrolchConfigurationException("Environment " + this.environment + " not configured in bootstrap configuration " + bootstrapFile.getAbsolutePath());
        }
        this.evaluatePaths();
    }

    private void parseBoostrapFile(InputStream bootstrapStream) {
        XmlHelper.parseDocument((InputStream)bootstrapStream, (DefaultHandler)this);
        if (!this.envFound) {
            throw new StrolchConfigurationException("Environment " + this.environment + " not configured in bootstrap configuration from given stream!");
        }
        this.evaluatePaths();
    }

    private void evaluatePaths() {
        if (!this.defaultAllowed && (StringHelper.isEmpty((String)this.configS) || StringHelper.isEmpty((String)this.dataS) || StringHelper.isEmpty((String)this.tempS))) {
            String msg = "One element of " + Arrays.toString(new String[]{"config", "data", "temp"}) + " is not set and environment " + this.environment + " does not have attribute " + DEFAULT + "=\"true\". Either set the value or allow using default values!";
            throw new StrolchConfigurationException(msg);
        }
        String root = StringHelper.isEmpty((String)this.rootS) ? new File(System.getProperty(SYS_PROP_USER_DIR)).getAbsolutePath() : this.rootS;
        String config = StringHelper.isEmpty((String)this.configS) ? "config" : this.configS;
        String data = StringHelper.isEmpty((String)this.dataS) ? "data" : this.dataS;
        String temp = StringHelper.isEmpty((String)this.tempS) ? "temp" : this.tempS;
        File rootPathF = new File(root);
        File tmp = new File(config);
        this.configPathF = tmp.isAbsolute() ? tmp : new File(rootPathF, config);
        tmp = new File(data);
        this.dataPathF = tmp.isAbsolute() ? tmp : new File(rootPathF, data);
        tmp = new File(temp);
        this.tempPathF = tmp.isAbsolute() ? tmp : new File(rootPathF, temp);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (qName) {
            case "StrolchBootstrap": {
                break;
            }
            case "env": {
                if (attributes.getValue(ID).equals(this.environment)) {
                    this.insideEnv = true;
                    this.envFound = true;
                } else {
                    this.insideEnv = false;
                }
                String defaultS = attributes.getValue(DEFAULT);
                this.defaultAllowed = defaultS == null ? false : StringHelper.parseBoolean((String)defaultS);
                break;
            }
            case "environment": 
            case "root": 
            case "config": 
            case "data": 
            case "temp": {
                if (!this.insideEnv) break;
                this.textB = new StringBuilder();
                break;
            }
            default: {
                throw new StrolchConfigurationException("Unhandled element " + qName);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (qName) {
            case "StrolchBootstrap": {
                break;
            }
            case "env": {
                this.insideEnv = false;
                break;
            }
            case "environment": {
                if (!this.insideEnv) break;
                this.environmentOverride = this.textB.toString();
                break;
            }
            case "root": {
                if (!this.insideEnv) break;
                this.rootS = this.textB.toString();
                break;
            }
            case "config": {
                if (!this.insideEnv) break;
                this.configS = this.textB.toString();
                break;
            }
            case "data": {
                if (!this.insideEnv) break;
                this.dataS = this.textB.toString();
                break;
            }
            case "temp": {
                if (!this.insideEnv) break;
                this.tempS = this.textB.toString();
                break;
            }
            default: {
                throw new StrolchConfigurationException("Unhandled element " + qName);
            }
        }
        this.textB = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.textB != null) {
            this.textB.append(ch, start, length);
        }
    }
}

