/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.api;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.ComponentState;
import li.strolch.agent.api.ComponentVersion;
import li.strolch.privilege.base.PrivilegeException;
import li.strolch.privilege.handler.SystemAction;
import li.strolch.privilege.handler.SystemActionWithResult;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.runtime.privilege.PrivilegedRunnable;
import li.strolch.runtime.privilege.PrivilegedRunnableWithResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrolchComponent {
    public static final String COMPONENT_VERSION_PROPERTIES = "/componentVersion.properties";
    protected static final Logger logger = LoggerFactory.getLogger(StrolchComponent.class);
    private final ComponentContainer container;
    private final String componentName;
    private ComponentState state;
    private ComponentVersion version;
    private ComponentConfiguration configuration;

    public StrolchComponent(ComponentContainer container, String componentName) {
        this.container = container;
        this.componentName = componentName;
        this.state = ComponentState.UNDEFINED;
    }

    public String getName() {
        return this.componentName;
    }

    public ComponentState getState() {
        return this.state;
    }

    protected ComponentContainer getContainer() {
        return this.container;
    }

    protected ComponentConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void assertStarted() {
        if (this.getState() != ComponentState.STARTED) {
            String msg = "Component {0} is not yet started!";
            throw new IllegalStateException(MessageFormat.format(msg, this.componentName));
        }
    }

    protected void assertContainerStarted() {
        if (this.container.getState() != ComponentState.STARTED) {
            String msg = "Container is not yet started!";
            throw new IllegalStateException(msg);
        }
    }

    public void setup(ComponentConfiguration configuration) {
        this.state = this.state.validateStateChange(ComponentState.SETUP);
    }

    public void initialize(ComponentConfiguration configuration) throws Exception {
        this.configuration = configuration;
        this.state = this.state.validateStateChange(ComponentState.INITIALIZED);
    }

    public void start() throws Exception {
        this.state = this.state.validateStateChange(ComponentState.STARTED);
    }

    public void stop() throws Exception {
        this.state = this.state.validateStateChange(ComponentState.STOPPED);
    }

    public void destroy() throws Exception {
        this.state = this.state.validateStateChange(ComponentState.DESTROYED);
    }

    protected void runAs(String username, SystemAction action) throws PrivilegeException {
        this.container.getPrivilegeHandler().runAs(username, action);
    }

    protected <T> T runWithResult(String username, SystemActionWithResult<T> action) throws PrivilegeException {
        return this.container.getPrivilegeHandler().runWithResult(username, action);
    }

    protected void runAs(String username, PrivilegedRunnable runnable) throws PrivilegeException {
        this.container.getPrivilegeHandler().runAs(username, runnable);
    }

    protected <T> T runWithResult(String username, PrivilegedRunnableWithResult<T> runnable) throws PrivilegeException {
        return this.container.getPrivilegeHandler().runWithResult(username, runnable);
    }

    protected void runAsAgent(SystemAction action) throws PrivilegeException {
        this.container.getPrivilegeHandler().runAsAgent(action);
    }

    protected <T> T runAsAgentWithResult(SystemActionWithResult<T> action) throws PrivilegeException {
        return this.container.getPrivilegeHandler().runAsAgentWithResult(action);
    }

    protected void runAsAgent(PrivilegedRunnable runnable) throws PrivilegeException {
        this.container.getPrivilegeHandler().runAsAgent(runnable);
    }

    protected <T> T runAsAgentWithResult(PrivilegedRunnableWithResult<T> runnable) throws PrivilegeException {
        return this.container.getPrivilegeHandler().runAsAgentWithResult(runnable);
    }

    public ComponentVersion getVersion() throws IOException {
        if (this.version == null) {
            try (InputStream stream = this.getClass().getResourceAsStream(COMPONENT_VERSION_PROPERTIES);){
                ComponentVersion componentVersion;
                if (stream == null) {
                    throw new RuntimeException("/componentVersion.properties does not exist");
                }
                Properties properties = new Properties();
                properties.load(stream);
                this.version = componentVersion = new ComponentVersion(this.getName(), properties);
            }
        }
        return this.version;
    }
}

