/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import li.strolch.agent.api.AuditTrail;
import li.strolch.model.audit.Audit;
import li.strolch.model.audit.AuditQuery;
import li.strolch.model.audit.AuditVisitor;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.utils.collections.DateRange;
import li.strolch.utils.dbc.DBC;

public class AuditingAuditMapFacade
implements AuditTrail {
    private AuditTrail auditTrail;
    private Set<Audit> read;
    private Set<Audit> created;
    private Set<Audit> updated;
    private Set<Audit> deleted;
    private long deletedAll;
    private Map<String, Long> deletedAllByType;
    private boolean observeAccessReads;

    public AuditingAuditMapFacade(AuditTrail auditTrail, boolean observeAccessReads) {
        DBC.PRE.assertNotNull("auditTrail must be set!", (Object)auditTrail);
        this.auditTrail = auditTrail;
        this.observeAccessReads = observeAccessReads;
        this.created = new HashSet<Audit>();
        this.read = new HashSet<Audit>();
        this.updated = new HashSet<Audit>();
        this.deleted = new HashSet<Audit>();
        this.deletedAllByType = new HashMap<String, Long>();
    }

    public Set<Audit> getRead() {
        return this.read;
    }

    public Set<Audit> getCreated() {
        return this.created;
    }

    public Set<Audit> getUpdated() {
        return this.updated;
    }

    public Set<Audit> getDeleted() {
        return this.deleted;
    }

    public long getDeletedAll() {
        return this.deletedAll;
    }

    public Map<String, Long> getDeletedAllByType() {
        return this.deletedAllByType;
    }

    @Override
    public boolean isEnabled() {
        return this.auditTrail.isEnabled();
    }

    @Override
    public boolean hasAudit(StrolchTransaction tx, String type, Long id) {
        return this.auditTrail.hasAudit(tx, type, id);
    }

    @Override
    public long querySize(StrolchTransaction tx, DateRange dateRange) {
        return this.auditTrail.querySize(tx, dateRange);
    }

    @Override
    public long querySize(StrolchTransaction tx, String type, DateRange dateRange) {
        return this.auditTrail.querySize(tx, type, dateRange);
    }

    @Override
    public Set<String> getTypes(StrolchTransaction tx) {
        return this.auditTrail.getTypes(tx);
    }

    @Override
    public Audit getBy(StrolchTransaction tx, String type, Long id) {
        Audit audit = this.auditTrail.getBy(tx, type, id);
        if (this.observeAccessReads) {
            this.read.add(audit);
        }
        return audit;
    }

    @Override
    public List<Audit> getAllElements(StrolchTransaction tx, String type, DateRange dateRange) {
        List<Audit> elements = this.auditTrail.getAllElements(tx, type, dateRange);
        if (this.observeAccessReads) {
            this.read.addAll(elements);
        }
        return elements;
    }

    @Override
    public void add(StrolchTransaction tx, Audit audit) {
        this.auditTrail.add(tx, audit);
        this.created.add(audit);
    }

    @Override
    public void addAll(StrolchTransaction tx, List<Audit> audits) {
        this.auditTrail.addAll(tx, audits);
        this.created.addAll(audits);
    }

    @Override
    public Audit update(StrolchTransaction tx, Audit audit) {
        Audit replaced = this.auditTrail.update(tx, audit);
        this.updated.add(audit);
        return replaced;
    }

    @Override
    public List<Audit> updateAll(StrolchTransaction tx, List<Audit> audits) {
        List<Audit> replaced = this.auditTrail.updateAll(tx, audits);
        this.updated.addAll(audits);
        return replaced;
    }

    @Override
    public void remove(StrolchTransaction tx, Audit audit) {
        this.auditTrail.remove(tx, audit);
        this.deleted.add(audit);
    }

    @Override
    public void removeAll(StrolchTransaction tx, List<Audit> audits) {
        this.auditTrail.removeAll(tx, audits);
        this.deleted.addAll(audits);
    }

    @Override
    public long removeAll(StrolchTransaction tx, String type, DateRange dateRange) {
        long removed = this.auditTrail.removeAll(tx, type, dateRange);
        Long byType = this.deletedAllByType.get(type);
        if (byType == null) {
            byType = 0L;
        }
        byType = byType + removed;
        this.deletedAllByType.put(type, byType);
        return removed;
    }

    @Override
    public <U> List<U> doQuery(StrolchTransaction tx, AuditQuery<U> query) {
        AuditVisitor auditVisitor = query.getAuditVisitor();
        query.setAuditVisitor(audit -> {
            this.read.add(audit);
            return auditVisitor.visitAudit(audit);
        });
        return this.auditTrail.doQuery(tx, query);
    }
}

