/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import li.strolch.agent.api.AuditTrail;
import li.strolch.model.audit.Audit;
import li.strolch.model.audit.AuditQuery;
import li.strolch.persistence.api.AuditDao;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.persistence.inmemory.InMemoryAuditDao;
import li.strolch.utils.collections.DateRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedAuditTrail
implements AuditTrail {
    private static final Logger logger = LoggerFactory.getLogger(CachedAuditTrail.class);
    private AuditDao cachedDao = new InMemoryAuditDao();

    @Override
    public boolean isEnabled() {
        return true;
    }

    protected AuditDao getCachedDao() {
        return this.cachedDao;
    }

    protected AuditDao getDbDao(StrolchTransaction tx) {
        return tx.getPersistenceHandler().getAuditDao(tx);
    }

    @Override
    public synchronized boolean hasAudit(StrolchTransaction tx, String type, Long id) {
        return this.getCachedDao().hasElement(type, id);
    }

    @Override
    public long querySize(StrolchTransaction tx, DateRange dateRange) {
        return this.getCachedDao().querySize(dateRange);
    }

    @Override
    public synchronized long querySize(StrolchTransaction tx, String type, DateRange dateRange) {
        return this.getCachedDao().querySize(type, dateRange);
    }

    @Override
    public synchronized Set<String> getTypes(StrolchTransaction tx) {
        return this.getCachedDao().queryTypes();
    }

    @Override
    public synchronized Audit getBy(StrolchTransaction tx, String type, Long id) {
        return this.getCachedDao().queryBy(type, id);
    }

    @Override
    public synchronized List<Audit> getAllElements(StrolchTransaction tx, String type, DateRange dateRange) {
        return this.getCachedDao().queryAll(type, dateRange);
    }

    @Override
    public synchronized void add(StrolchTransaction tx, Audit audit) {
        this.getCachedDao().save(audit);
        this.getDbDao(tx).save(audit);
    }

    @Override
    public synchronized void addAll(StrolchTransaction tx, List<Audit> audits) {
        this.getCachedDao().saveAll(audits);
        this.getDbDao(tx).saveAll(audits);
    }

    @Override
    public synchronized Audit update(StrolchTransaction tx, Audit audit) {
        this.getCachedDao().update(audit);
        this.getDbDao(tx).update(audit);
        return audit;
    }

    @Override
    public synchronized List<Audit> updateAll(StrolchTransaction tx, List<Audit> audits) {
        this.getCachedDao().updateAll(audits);
        this.getDbDao(tx).updateAll(audits);
        return audits;
    }

    @Override
    public synchronized void remove(StrolchTransaction tx, Audit audit) {
        this.getCachedDao().remove(audit);
        this.getDbDao(tx).remove(audit);
    }

    @Override
    public synchronized void removeAll(StrolchTransaction tx, List<Audit> audits) {
        this.getCachedDao().removeAll(audits);
        this.getDbDao(tx).removeAll(audits);
    }

    @Override
    public synchronized long removeAll(StrolchTransaction tx, String type, DateRange dateRange) {
        long daoRemoved;
        long removed = this.getCachedDao().removeAll(type, dateRange);
        if (removed != (daoRemoved = this.getDbDao(tx).removeAll(type, dateRange))) {
            String msg = "Removed {0} elements from cached map, but dao removed {1} elements!";
            logger.error(MessageFormat.format(msg, removed, daoRemoved));
        }
        return removed;
    }

    @Override
    public <U> List<U> doQuery(StrolchTransaction tx, AuditQuery<U> query) {
        return this.getDbDao(tx).doQuery(query);
    }
}

