/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import li.strolch.agent.api.ElementMap;
import li.strolch.agent.api.StrolchAgent;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.exception.StrolchException;
import li.strolch.model.StrolchRootElement;
import li.strolch.model.Version;
import li.strolch.model.parameter.Parameter;
import li.strolch.model.parameter.StringListParameter;
import li.strolch.model.parameter.StringParameter;
import li.strolch.persistence.api.StrolchDao;
import li.strolch.persistence.api.StrolchPersistenceException;
import li.strolch.persistence.api.StrolchTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachedElementMap<T extends StrolchRootElement>
implements ElementMap<T> {
    private static final Logger logger = LoggerFactory.getLogger(CachedElementMap.class);
    private StrolchRealm realm;

    public CachedElementMap(StrolchRealm realm) {
        this.realm = realm;
    }

    protected StrolchRealm getRealm() {
        return this.realm;
    }

    protected abstract StrolchDao<T> getCachedDao();

    protected abstract StrolchDao<T> getDbDao(StrolchTransaction var1);

    @Override
    public synchronized boolean hasType(StrolchTransaction tx, String type) {
        return this.getCachedDao().queryTypes().contains(type);
    }

    @Override
    public synchronized boolean hasElement(StrolchTransaction tx, String type, String id) {
        return this.getCachedDao().hasElement(type, id);
    }

    @Override
    public synchronized long querySize(StrolchTransaction tx) {
        return this.getCachedDao().querySize();
    }

    @Override
    public synchronized long querySize(StrolchTransaction tx, String type) {
        return this.getCachedDao().querySize(type);
    }

    @Override
    public synchronized T getTemplate(StrolchTransaction tx, String type) {
        return this.getTemplate(tx, type, false);
    }

    @Override
    public T getTemplate(StrolchTransaction tx, String type, boolean assertExists) {
        T t = this.getCachedDao().queryBy("Template", type);
        if (assertExists && t == null) {
            String msg = "The template for type {0} does not exist!";
            throw new StrolchException(MessageFormat.format(msg, type));
        }
        if (t == null) {
            return null;
        }
        StrolchRootElement clone = (StrolchRootElement)t.getClone();
        clone.setId(StrolchAgent.getUniqueId());
        clone.setType(type);
        return (T)clone;
    }

    @Override
    public synchronized T getBy(StrolchTransaction tx, String type, String id) {
        return this.getBy(tx, type, id, false);
    }

    @Override
    public T getBy(StrolchTransaction tx, String type, String id, boolean assertExists) throws StrolchException {
        T t = this.getCachedDao().queryBy(type, id);
        if (assertExists && t == null) {
            String msg = "The element for type {0} and id {1} does not exist!";
            throw new StrolchException(MessageFormat.format(msg, type, id));
        }
        if (t == null) {
            return null;
        }
        StrolchRootElement clone = (StrolchRootElement)t.getClone();
        clone.setVersion(t.getVersion());
        return (T)clone;
    }

    @Override
    public T getBy(StrolchTransaction tx, String type, String id, int version) {
        return this.getBy(tx, type, id, version, false);
    }

    @Override
    public T getBy(StrolchTransaction tx, String type, String id, int version, boolean assertExists) throws StrolchException {
        T t = this.getDbDao(tx).queryBy(type, id, version);
        if (assertExists && t == null) {
            String msg = "The element for type {0} and id {1} and version {2} does not exist!";
            msg = MessageFormat.format(msg, type, id, version);
            throw new StrolchException(msg);
        }
        return t;
    }

    @Override
    public T getBy(StrolchTransaction tx, StringParameter refP, boolean assertExists) throws StrolchException {
        this.assertIsRefParam((Parameter<?>)refP);
        String type = refP.getUom();
        String id = refP.getValue();
        return this.getBy(tx, type, id, assertExists);
    }

    @Override
    public List<T> getBy(StrolchTransaction tx, StringListParameter refP, boolean assertExists) throws StrolchException {
        this.assertIsRefParam((Parameter<?>)refP);
        String type = refP.getUom();
        List ids = refP.getValue();
        return ids.stream().map(id -> this.getBy(tx, type, (String)id, assertExists)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<T> getVersionsFor(StrolchTransaction tx, String type, String id) {
        return this.getDbDao(tx).queryVersionsFor(type, id);
    }

    @Override
    public synchronized List<T> getAllElements(StrolchTransaction tx) {
        List<T> all = this.getCachedDao().queryAll();
        return all.stream().map(t -> {
            StrolchRootElement clone = (StrolchRootElement)t.getClone();
            clone.setVersion(t.getVersion());
            return clone;
        }).collect(Collectors.toList());
    }

    @Override
    public synchronized List<T> getElementsBy(StrolchTransaction tx, String type) {
        List<T> all = this.getCachedDao().queryAll(type);
        return all.stream().map(t -> {
            StrolchRootElement clone = (StrolchRootElement)t.getClone();
            clone.setVersion(t.getVersion());
            return clone;
        }).collect(Collectors.toList());
    }

    @Override
    public synchronized Set<String> getTypes(StrolchTransaction tx) {
        return this.getCachedDao().queryTypes();
    }

    @Override
    public synchronized Set<String> getAllKeys(StrolchTransaction tx) {
        return this.getCachedDao().queryKeySet();
    }

    @Override
    public synchronized Set<String> getKeysBy(StrolchTransaction tx, String type) {
        return this.getCachedDao().queryKeySet(type);
    }

    synchronized void insert(T element) {
        this.getCachedDao().save(element);
    }

    @Override
    public synchronized void add(StrolchTransaction tx, T element) {
        if (this.realm.isVersioningEnabled()) {
            Version.updateVersionFor(element, (String)tx.getCertificate().getUsername(), (boolean)false);
        } else {
            Version.setInitialVersionFor(element, (String)tx.getCertificate().getUsername());
        }
        this.getCachedDao().save(element);
        this.getDbDao(tx).save(element);
    }

    @Override
    public synchronized void addAll(StrolchTransaction tx, List<T> elements) {
        for (StrolchRootElement element : elements) {
            if (this.realm.isVersioningEnabled()) {
                Version.updateVersionFor((StrolchRootElement)element, (String)tx.getCertificate().getUsername(), (boolean)false);
                continue;
            }
            Version.setInitialVersionFor((StrolchRootElement)element, (String)tx.getCertificate().getUsername());
        }
        this.getCachedDao().saveAll(elements);
        this.getDbDao(tx).saveAll(elements);
    }

    @Override
    public synchronized void update(StrolchTransaction tx, T element) {
        if (this.realm.isVersioningEnabled()) {
            Version.updateVersionFor(element, (String)tx.getCertificate().getUsername(), (boolean)false);
        } else {
            Version.setInitialVersionFor(element, (String)tx.getCertificate().getUsername());
        }
        this.getCachedDao().update(element);
        this.getDbDao(tx).update(element);
    }

    @Override
    public synchronized void updateAll(StrolchTransaction tx, List<T> elements) {
        for (StrolchRootElement t : elements) {
            if (this.realm.isVersioningEnabled()) {
                Version.updateVersionFor((StrolchRootElement)t, (String)tx.getCertificate().getUsername(), (boolean)false);
                continue;
            }
            Version.setInitialVersionFor((StrolchRootElement)t, (String)tx.getCertificate().getUsername());
        }
        this.getCachedDao().updateAll(elements);
        this.getDbDao(tx).updateAll(elements);
    }

    @Override
    public synchronized void remove(StrolchTransaction tx, T element) {
        if (this.realm.isVersioningEnabled()) {
            Version.updateVersionFor(element, (String)tx.getCertificate().getUsername(), (boolean)true);
        } else {
            Version.setInitialVersionFor(element, (String)tx.getCertificate().getUsername());
        }
        if (this.realm.isVersioningEnabled()) {
            this.getCachedDao().remove(element);
            this.getDbDao(tx).update(element);
        } else {
            this.getCachedDao().remove(element);
            this.getDbDao(tx).remove(element);
        }
    }

    @Override
    public synchronized void removeAll(StrolchTransaction tx, List<T> elements) {
        for (StrolchRootElement t : elements) {
            if (this.realm.isVersioningEnabled()) {
                Version.updateVersionFor((StrolchRootElement)t, (String)tx.getCertificate().getUsername(), (boolean)true);
                continue;
            }
            Version.setInitialVersionFor((StrolchRootElement)t, (String)tx.getCertificate().getUsername());
        }
        if (this.realm.isVersioningEnabled()) {
            this.getCachedDao().removeAll(elements);
            this.getDbDao(tx).updateAll(elements);
        } else {
            this.getCachedDao().removeAll(elements);
            this.getDbDao(tx).removeAll(elements);
        }
    }

    @Override
    public synchronized long removeAll(StrolchTransaction tx) {
        long daoRemoved;
        long removed = this.getCachedDao().removeAll();
        if (removed != (daoRemoved = this.getDbDao(tx).removeAll())) {
            String msg = "Removed {0} elements from cached map, but dao removed {1} elements!";
            logger.error(MessageFormat.format(msg, removed, daoRemoved));
        }
        return removed;
    }

    @Override
    public synchronized long removeAllBy(StrolchTransaction tx, String type) {
        long daoRemoved;
        long removed = this.getCachedDao().removeAllBy(type);
        if (removed != (daoRemoved = this.getDbDao(tx).removeAllBy(type))) {
            String msg = "Removed {0} elements from cached map for type {1}, but dao removed {3} elements!";
            logger.error(MessageFormat.format(msg, removed, type, daoRemoved));
        }
        return removed;
    }

    @Override
    public T revertToVersion(StrolchTransaction tx, T element) throws StrolchException {
        return this.revertToVersion(tx, element.getType(), element.getId(), element.getVersion().getVersion());
    }

    @Override
    public T revertToVersion(StrolchTransaction tx, String type, String id, int version) throws StrolchException {
        if (!this.realm.isVersioningEnabled()) {
            throw new StrolchPersistenceException("Can not und a version if versioning is not enabled!");
        }
        T current = this.getBy(tx, type, id, true);
        T versionT = this.getBy(tx, type, id, version, true);
        StrolchRootElement clone = (StrolchRootElement)versionT.getClone();
        clone.setVersion(current.getVersion().next(tx.getCertificate().getUsername(), false));
        this.getCachedDao().update(clone);
        this.getDbDao(tx).update(clone);
        return (T)clone;
    }

    @Override
    public void undoVersion(StrolchTransaction tx, T element) throws StrolchException {
        if (!this.realm.isVersioningEnabled()) {
            throw new StrolchPersistenceException("Can not und a version if versioning is not enabled!");
        }
        String type = element.getType();
        String id = element.getId();
        Version elementVersion = element.getVersion();
        T current = this.getBy(tx, type, id, true);
        if (!current.getVersion().equals((Object)elementVersion)) {
            String msg = "Can not undo the version {0} as it is not the latest!";
            msg = MessageFormat.format(msg, elementVersion);
            throw new StrolchException(msg);
        }
        if (elementVersion.isFirstVersion()) {
            this.getCachedDao().remove(element);
            this.getDbDao(tx).remove(element);
        } else {
            T previous = this.getBy(tx, type, id, elementVersion.getPreviousVersion(), true);
            this.getCachedDao().update(previous);
            this.getDbDao(tx).removeVersion(current);
        }
    }

    protected abstract void assertIsRefParam(Parameter<?> var1);
}

