/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import li.strolch.agent.api.ActivityMap;
import li.strolch.agent.api.AuditTrail;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.OrderMap;
import li.strolch.agent.api.ResourceMap;
import li.strolch.agent.impl.CachedActivityMap;
import li.strolch.agent.impl.CachedAuditTrail;
import li.strolch.agent.impl.CachedOrderMap;
import li.strolch.agent.impl.CachedResourceMap;
import li.strolch.agent.impl.DataStoreMode;
import li.strolch.agent.impl.InternalStrolchRealm;
import li.strolch.agent.impl.NoStrategyAuditTrail;
import li.strolch.model.Order;
import li.strolch.model.Resource;
import li.strolch.model.activity.Activity;
import li.strolch.persistence.api.ActivityDao;
import li.strolch.persistence.api.OrderDao;
import li.strolch.persistence.api.PersistenceHandler;
import li.strolch.persistence.api.ResourceDao;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.privilege.model.Certificate;
import li.strolch.privilege.model.PrivilegeContext;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.utils.dbc.DBC;
import li.strolch.utils.helper.StringHelper;

public class CachedRealm
extends InternalStrolchRealm {
    private PersistenceHandler persistenceHandler;
    private CachedResourceMap resourceMap;
    private CachedOrderMap orderMap;
    private CachedActivityMap activityMap;
    private AuditTrail auditTrail;

    public CachedRealm(String realm) {
        super(realm);
    }

    @Override
    public DataStoreMode getMode() {
        return DataStoreMode.CACHED;
    }

    @Override
    public StrolchTransaction openTx(Certificate certificate, String action) {
        DBC.PRE.assertNotNull("Certificate must be set!", (Object)certificate);
        return this.persistenceHandler.openTx(this, certificate, action);
    }

    @Override
    public StrolchTransaction openTx(Certificate certificate, Class<?> clazz) {
        DBC.PRE.assertNotNull("Certificate must be set!", (Object)certificate);
        return this.persistenceHandler.openTx(this, certificate, clazz.getName());
    }

    @Override
    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    @Override
    public OrderMap getOrderMap() {
        return this.orderMap;
    }

    @Override
    public ActivityMap getActivityMap() {
        return this.activityMap;
    }

    @Override
    public AuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    @Override
    public void initialize(ComponentContainer container, ComponentConfiguration configuration) {
        super.initialize(container, configuration);
        this.persistenceHandler = container.getComponent(PersistenceHandler.class);
        this.resourceMap = new CachedResourceMap(this);
        this.orderMap = new CachedOrderMap(this);
        this.activityMap = new CachedActivityMap(this);
        this.auditTrail = this.isAuditTrailEnabled() ? new CachedAuditTrail() : new NoStrategyAuditTrail();
    }

    @Override
    public void start(PrivilegeContext privilegeContext) {
        long start = System.nanoTime();
        int nrOfOrders = 0;
        int nrOfResources = 0;
        int nrOfActivities = 0;
        try (StrolchTransaction tx = this.openTx(privilegeContext.getCertificate(), "strolch_boot");){
            ResourceDao resourceDao = tx.getPersistenceHandler().getResourceDao(tx);
            Set<String> resourceTypes = resourceDao.queryTypes();
            for (String type : resourceTypes) {
                List resources = resourceDao.queryAll(type);
                for (Resource resource : resources) {
                    this.resourceMap.insert(resource);
                    ++nrOfResources;
                }
            }
            tx.commitOnClose();
        }
        tx = this.openTx(privilegeContext.getCertificate(), "strolch_boot");
        var8_8 = null;
        try {
            OrderDao orderDao = tx.getPersistenceHandler().getOrderDao(tx);
            Set<String> orderTypes = orderDao.queryTypes();
            for (String type : orderTypes) {
                List orders = orderDao.queryAll(type);
                for (Order order : orders) {
                    this.orderMap.insert(order);
                    ++nrOfOrders;
                }
            }
            tx.commitOnClose();
        }
        catch (Throwable orderDao) {
            var8_8 = orderDao;
            throw orderDao;
        }
        finally {
            if (tx != null) {
                if (var8_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable orderDao) {
                        var8_8.addSuppressed(orderDao);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.openTx(privilegeContext.getCertificate(), "strolch_boot");
        var8_8 = null;
        try {
            ActivityDao activityDao = tx.getPersistenceHandler().getActivityDao(tx);
            Set<String> activityTypes = activityDao.queryTypes();
            for (String type : activityTypes) {
                List activities = activityDao.queryAll(type);
                for (Activity activity : activities) {
                    this.activityMap.insert(activity);
                    ++nrOfActivities;
                }
            }
            tx.commitOnClose();
        }
        catch (Throwable activityDao) {
            var8_8 = activityDao;
            throw activityDao;
        }
        finally {
            if (tx != null) {
                if (var8_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable activityDao) {
                        var8_8.addSuppressed(activityDao);
                    }
                } else {
                    tx.close();
                }
            }
        }
        long duration = System.nanoTime() - start;
        String durationS = StringHelper.formatNanoDuration((long)duration);
        logger.info(MessageFormat.format("Loading Model from Database for realm {0} took {1}.", this.getRealm(), durationS));
        logger.info(MessageFormat.format("Loaded {0} Orders", nrOfOrders));
        logger.info(MessageFormat.format("Loaded {0} Resources", nrOfResources));
        logger.info(MessageFormat.format("Loaded {0} Activities", nrOfActivities));
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }
}

