/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import java.util.Set;
import li.strolch.agent.api.ComponentState;
import li.strolch.agent.api.StrolchComponent;
import li.strolch.agent.impl.ComponentController;
import li.strolch.agent.impl.ComponentDependencyAnalyzer;
import li.strolch.exception.StrolchException;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.runtime.configuration.StrolchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentContainerStateHandler {
    private static final Logger logger = LoggerFactory.getLogger(ComponentContainerStateHandler.class);
    private ComponentDependencyAnalyzer dependencyAnalyzer;
    private StrolchConfiguration strolchConfiguration;

    public ComponentContainerStateHandler(ComponentDependencyAnalyzer dependencyAnalyzer, StrolchConfiguration strolchConfiguration) {
        this.dependencyAnalyzer = dependencyAnalyzer;
        this.strolchConfiguration = strolchConfiguration;
    }

    public void initialize(Set<ComponentController> controllers) {
        for (ComponentController controller : controllers) {
            if (controller.getState() == ComponentState.INITIALIZED) continue;
            StrolchComponent component = controller.getComponent();
            String componentName = component.getName();
            ComponentConfiguration componentConfiguration = this.strolchConfiguration.getComponentConfiguration(componentName);
            String msg = "Initializing component {0}...";
            logger.info(MessageFormat.format(msg, componentName));
            try {
                component.initialize(componentConfiguration);
            }
            catch (Exception e) {
                throw new StrolchException(MessageFormat.format("Failed to initialize component {0}", componentName), (Throwable)e);
            }
        }
        Set<ComponentController> dependencies = this.dependencyAnalyzer.collectDirectDownstreamDependencies(controllers);
        if (!dependencies.isEmpty()) {
            this.initialize(dependencies);
        }
    }

    public void start(Set<ComponentController> controllers) {
        for (ComponentController controller : controllers) {
            if (controller.getState() == ComponentState.STARTED) continue;
            StrolchComponent component = controller.getComponent();
            String msg = "Starting component {0}...";
            String componentName = component.getName();
            logger.info(MessageFormat.format(msg, componentName));
            try {
                component.start();
            }
            catch (Exception e) {
                throw new StrolchException(MessageFormat.format("Failed to start component {0}", componentName), (Throwable)e);
            }
        }
        Set<ComponentController> dependencies = this.dependencyAnalyzer.collectDirectDownstreamDependencies(controllers);
        if (!dependencies.isEmpty()) {
            this.start(dependencies);
        }
    }

    public void stop(Set<ComponentController> controllers) {
        for (ComponentController controller : controllers) {
            if (controller.getState() == ComponentState.STOPPED) continue;
            StrolchComponent component = controller.getComponent();
            String msg = "Stopping component {0}...";
            String componentName = component.getName();
            logger.info(MessageFormat.format(msg, componentName));
            try {
                component.stop();
            }
            catch (Exception e) {
                msg = "Failed to stop component {0} due to {1}";
                msg = MessageFormat.format(msg, componentName, e.getMessage());
                logger.error(msg, (Throwable)e);
            }
        }
        Set<ComponentController> dependencies = this.dependencyAnalyzer.collectDirectUpstreamDependencies(controllers);
        if (!dependencies.isEmpty()) {
            this.stop(dependencies);
        }
    }

    public void destroy(Set<ComponentController> controllers) {
        for (ComponentController controller : controllers) {
            if (controller.getState() == ComponentState.DESTROYED) continue;
            StrolchComponent component = controller.getComponent();
            String msg = "Destroying component {0}...";
            String componentName = component.getName();
            logger.info(MessageFormat.format(msg, componentName));
            try {
                component.destroy();
            }
            catch (Exception e) {
                msg = "Failed to destroy component {0} due to {1}";
                msg = MessageFormat.format(msg, componentName, e.getMessage());
                logger.error(msg, (Throwable)e);
            }
        }
        Set<ComponentController> dependencies = this.dependencyAnalyzer.collectDirectUpstreamDependencies(controllers);
        if (!dependencies.isEmpty()) {
            this.destroy(dependencies);
        }
    }
}

