/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import li.strolch.agent.api.ComponentState;
import li.strolch.agent.api.StrolchComponent;
import li.strolch.runtime.configuration.StrolchConfigurationException;

public class ComponentController {
    private StrolchComponent component;
    private Set<ComponentController> upstreamDependencies;
    private Set<ComponentController> downstreamDependencies;

    public ComponentController(StrolchComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Component may not be null!");
        }
        this.component = component;
        this.upstreamDependencies = new HashSet<ComponentController>();
        this.downstreamDependencies = new HashSet<ComponentController>();
    }

    public ComponentState getState() {
        return this.component.getState();
    }

    public StrolchComponent getComponent() {
        return this.component;
    }

    public String getName() {
        return this.component.getName();
    }

    public Set<ComponentController> getUpstreamDependencies() {
        return new HashSet<ComponentController>(this.upstreamDependencies);
    }

    public Set<ComponentController> getDownstreamDependencies() {
        return new HashSet<ComponentController>(this.downstreamDependencies);
    }

    public boolean hasUpstreamDependencies() {
        return !this.upstreamDependencies.isEmpty();
    }

    public boolean hasDownstreamDependencies() {
        return !this.downstreamDependencies.isEmpty();
    }

    public void addUpstreamDependency(ComponentController controller) {
        if (this.equals(controller)) {
            String msg = "{0} can not depend on itself!";
            msg = MessageFormat.format(msg, controller);
            throw new StrolchConfigurationException(msg);
        }
        if (this.upstreamDependencies.contains(controller)) {
            return;
        }
        this.validateNoCyclicDependency(controller);
        this.upstreamDependencies.add(controller);
        controller.downstreamDependencies.add(this);
    }

    private void validateNoCyclicDependency(ComponentController controller) {
        if (controller.hasTransitiveUpstreamDependency(this)) {
            String msg = "{0} has transitive upstream dependeny to {1}!";
            msg = MessageFormat.format(msg, this, controller);
            throw new StrolchConfigurationException(msg);
        }
    }

    public boolean hasUpstreamDependency(ComponentController controller) {
        return this.upstreamDependencies.contains(controller);
    }

    public boolean hasDownstreamDependency(ComponentController controller) {
        return this.downstreamDependencies.contains(controller);
    }

    public boolean hasTransitiveDownstreamDependency(ComponentController controller) {
        if (this.hasDownstreamDependency(controller)) {
            return true;
        }
        for (ComponentController downstream : this.downstreamDependencies) {
            if (!downstream.hasTransitiveDownstreamDependency(controller)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTransitiveUpstreamDependency(ComponentController controller) {
        if (this.hasUpstreamDependency(controller)) {
            return true;
        }
        for (ComponentController upstream : this.upstreamDependencies) {
            if (!upstream.hasTransitiveUpstreamDependency(controller)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ComponentController [component=");
        builder.append(this.component.getName());
        builder.append("]");
        return builder.toString();
    }
}

