/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import li.strolch.agent.impl.ComponentController;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.runtime.configuration.StrolchConfiguration;
import li.strolch.runtime.configuration.StrolchConfigurationException;
import li.strolch.utils.dbc.DBC;
import li.strolch.utils.helper.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentDependencyAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(ComponentDependencyAnalyzer.class);
    private StrolchConfiguration strolchConfiguration;
    private Map<String, ComponentController> controllerMap;

    public ComponentDependencyAnalyzer(StrolchConfiguration strolchConfiguration, Map<String, ComponentController> controllerMap) {
        this.strolchConfiguration = strolchConfiguration;
        this.controllerMap = controllerMap;
    }

    public Set<ComponentController> findRootUpstreamComponents() {
        HashSet<ComponentController> controllers = new HashSet<ComponentController>();
        for (ComponentController controller : this.controllerMap.values()) {
            if (controller.hasUpstreamDependencies()) continue;
            controllers.add(controller);
        }
        return controllers;
    }

    public Set<ComponentController> findRootDownstreamComponents() {
        HashSet<ComponentController> controllers = new HashSet<ComponentController>();
        for (ComponentController controller : this.controllerMap.values()) {
            if (controller.hasDownstreamDependencies()) continue;
            controllers.add(controller);
        }
        return controllers;
    }

    private Set<ComponentController> collectAllUpstreamDependencies(ComponentController controller) {
        HashSet<ComponentController> upstreamDependencies = new HashSet<ComponentController>(controller.getUpstreamDependencies());
        for (ComponentController upstream : controller.getUpstreamDependencies()) {
            upstreamDependencies.addAll(this.collectAllUpstreamDependencies(upstream));
        }
        return upstreamDependencies;
    }

    public Set<ComponentController> collectDirectUpstreamDependencies(Set<ComponentController> controllers) {
        for (ComponentController componentController : controllers) {
            Set<ComponentController> upstreamDependencies = this.collectAllUpstreamDependencies(componentController);
            for (ComponentController upstream : upstreamDependencies) {
                DBC.INTERIM.assertFalse("Upstream " + upstream.getName() + " is one of the input controllers!", controllers.contains(upstream));
            }
        }
        HashSet<ComponentController> directUpstreamDependencies = new HashSet<ComponentController>();
        for (ComponentController controller : controllers) {
            Set<ComponentController> upstreamDependencies = controller.getUpstreamDependencies();
            directUpstreamDependencies.addAll(upstreamDependencies);
        }
        HashSet hashSet = new HashSet(directUpstreamDependencies);
        for (ComponentController controller : hashSet) {
            Set<ComponentController> upstreamDeps = this.collectAllUpstreamDependencies(controller);
            directUpstreamDependencies.removeAll(upstreamDeps);
        }
        return directUpstreamDependencies;
    }

    private Set<ComponentController> collectAllDownstreamDependencies(ComponentController controller) {
        HashSet<ComponentController> downstreamDependencies = new HashSet<ComponentController>(controller.getDownstreamDependencies());
        for (ComponentController downstream : controller.getDownstreamDependencies()) {
            downstreamDependencies.addAll(this.collectAllDownstreamDependencies(downstream));
        }
        return downstreamDependencies;
    }

    public Set<ComponentController> collectDirectDownstreamDependencies(Set<ComponentController> controllers) {
        for (ComponentController componentController : controllers) {
            Set<ComponentController> downstreamDependencies = this.collectAllUpstreamDependencies(componentController);
            for (ComponentController downstream : downstreamDependencies) {
                DBC.INTERIM.assertFalse("Downstream " + downstream.getName() + " is one of the input controllers!", controllers.contains(downstream));
            }
        }
        HashSet<ComponentController> directDownstreamDependencies = new HashSet<ComponentController>();
        for (ComponentController controller : controllers) {
            Set<ComponentController> downstreamDependencies = controller.getDownstreamDependencies();
            directDownstreamDependencies.addAll(downstreamDependencies);
        }
        HashSet hashSet = new HashSet(directDownstreamDependencies);
        for (ComponentController controller : hashSet) {
            Set<ComponentController> downstreamDeps = this.collectAllDownstreamDependencies(controller);
            directDownstreamDependencies.removeAll(downstreamDeps);
        }
        return directDownstreamDependencies;
    }

    public void setupDependencies() {
        for (ComponentController controller : this.controllerMap.values()) {
            String name = controller.getComponent().getName();
            ComponentConfiguration configuration = this.strolchConfiguration.getComponentConfiguration(name);
            Set<String> dependencies = configuration.getDependencies();
            for (String dependencyName : dependencies) {
                ComponentController dependency = this.controllerMap.get(dependencyName);
                if (dependency == null) {
                    String msg = "Component {0} is missing required dependency {1}";
                    msg = MessageFormat.format(msg, name, dependencyName);
                    throw new StrolchConfigurationException(msg);
                }
                controller.addUpstreamDependency(dependency);
            }
        }
        this.logDependencies(1, this.findRootUpstreamComponents());
    }

    private void logDependencies(int depth, Set<ComponentController> components) {
        if (depth == 1) {
            logger.info("Dependency tree:");
        }
        String inset = StringHelper.normalizeLength((String)"", (int)(depth * 2), (boolean)false, (char)' ');
        for (ComponentController controller : components) {
            logger.info(inset + controller.getComponent().getName() + ": " + controller.getComponent().getClass().getName());
            this.logDependencies(depth + 1, controller.getDownstreamDependencies());
        }
    }
}

