/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import li.strolch.agent.impl.CachedRealm;
import li.strolch.agent.impl.EmptyRealm;
import li.strolch.agent.impl.InternalStrolchRealm;
import li.strolch.agent.impl.TransactionalRealm;
import li.strolch.agent.impl.TransientRealm;

public enum DataStoreMode {
    EMPTY{

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public InternalStrolchRealm createRealm(String realm) {
            return new EmptyRealm(realm);
        }
    }
    ,
    TRANSIENT{

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public InternalStrolchRealm createRealm(String realm) {
            return new TransientRealm(realm);
        }
    }
    ,
    CACHED{

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public InternalStrolchRealm createRealm(String realm) {
            return new CachedRealm(realm);
        }
    }
    ,
    TRANSACTIONAL{

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public InternalStrolchRealm createRealm(String realm) {
            return new TransactionalRealm(realm);
        }
    };


    public abstract InternalStrolchRealm createRealm(String var1);

    public abstract boolean isTransient();

    public static DataStoreMode parseDataStoreMode(String modeS) {
        for (DataStoreMode dataStoreMode : DataStoreMode.values()) {
            if (!dataStoreMode.name().endsWith(modeS)) continue;
            return dataStoreMode;
        }
        throw new IllegalArgumentException(MessageFormat.format("There is no data store mode ''{0}''", modeS));
    }
}

