/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import li.strolch.agent.api.LockHandler;
import li.strolch.agent.api.StrolchLockException;
import li.strolch.model.Locator;
import li.strolch.model.StrolchRootElement;
import li.strolch.utils.dbc.DBC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLockHandler
implements LockHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLockHandler.class);
    private String realm;
    private TimeUnit tryLockTimeUnit;
    private long tryLockTime;
    private Map<Locator, ReentrantLock> lockMap;

    public DefaultLockHandler(String realm, TimeUnit tryLockTimeUnit, long tryLockTime) {
        DBC.PRE.assertNotEmpty("Realm must be set!", realm);
        DBC.PRE.assertNotNull("TimeUnit must be set!", (Object)tryLockTimeUnit);
        DBC.PRE.assertNotEquals("try lock time must not be 0", (Object)0, (Object)tryLockTime);
        this.realm = realm;
        this.tryLockTimeUnit = tryLockTimeUnit;
        this.tryLockTime = tryLockTime;
        this.lockMap = new HashMap<Locator, ReentrantLock>();
    }

    public String getRealm() {
        return this.realm;
    }

    @Override
    public void lock(StrolchRootElement element) throws StrolchLockException {
        Locator locator = element.getLocator();
        ReentrantLock lock = this.lockMap.get(locator);
        if (lock == null) {
            lock = new ReentrantLock(true);
            this.lockMap.put(locator, lock);
        }
        this.lock(this.tryLockTimeUnit, this.tryLockTime, lock, element);
    }

    @Override
    public void unlock(StrolchRootElement element) throws StrolchLockException {
        Locator locator = element.getLocator();
        ReentrantLock lock = this.lockMap.get(locator);
        if (lock == null || !lock.isHeldByCurrentThread()) {
            logger.error(MessageFormat.format("Trying to unlock not locked element {0}", locator));
        } else {
            this.unlock(lock);
        }
    }

    @Override
    public void releaseLock(StrolchRootElement element) throws StrolchLockException {
        Locator locator = element.getLocator();
        ReentrantLock lock = this.lockMap.get(locator);
        if (lock == null || !lock.isHeldByCurrentThread()) {
            logger.error(MessageFormat.format("Trying to unlock not locked element {0}", locator));
        } else {
            this.releaseLock(lock);
        }
    }

    private void lock(TimeUnit timeUnit, long tryLockTime, ReentrantLock lock, StrolchRootElement element) throws StrolchLockException {
        try {
            if (!lock.tryLock(tryLockTime, timeUnit)) {
                String msg = "Failed to acquire lock after {0}s for {1}";
                msg = MessageFormat.format(msg, timeUnit.toSeconds(tryLockTime), element.getLocator());
                throw new StrolchLockException(msg);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("locked " + this.toString());
            }
        }
        catch (InterruptedException e) {
            throw new StrolchLockException(e.getMessage(), e);
        }
    }

    private void unlock(ReentrantLock lock) throws StrolchLockException {
        try {
            lock.unlock();
            if (logger.isDebugEnabled()) {
                logger.debug("unlocking " + this.toString());
            }
        }
        catch (IllegalMonitorStateException e) {
            throw new StrolchLockException(e.getMessage(), e);
        }
    }

    private void releaseLock(ReentrantLock lock) {
        while (lock.isHeldByCurrentThread() && lock.isLocked()) {
            this.unlock(lock);
        }
    }
}

