/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import li.strolch.agent.api.Observer;
import li.strolch.agent.api.ObserverHandler;
import li.strolch.model.StrolchRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultObserverHandler
implements ObserverHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultObserverHandler.class);
    private Map<String, List<Observer>> observerMap = new HashMap<String, List<Observer>>();

    @Override
    public void add(String key, List<StrolchRootElement> elements) {
        List<Observer> observerList = this.observerMap.get(key);
        if (observerList != null && !observerList.isEmpty()) {
            for (Observer observer : observerList) {
                try {
                    observer.add(key, elements);
                }
                catch (Exception e) {
                    String msg = "Failed to update observer {0} with {1} due to {2}";
                    msg = MessageFormat.format(msg, key, observer, e.getMessage());
                    logger.error(msg, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void update(String key, List<StrolchRootElement> elements) {
        List<Observer> observerList = this.observerMap.get(key);
        if (observerList != null && !observerList.isEmpty()) {
            for (Observer observer : observerList) {
                try {
                    observer.update(key, elements);
                }
                catch (Exception e) {
                    String msg = "Failed to update observer {0} with {1} due to {2}";
                    msg = MessageFormat.format(msg, key, observer, e.getMessage());
                    logger.error(msg, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void remove(String key, List<StrolchRootElement> elements) {
        List<Observer> observerList = this.observerMap.get(key);
        if (observerList != null && !observerList.isEmpty()) {
            for (Observer observer : observerList) {
                try {
                    observer.remove(key, elements);
                }
                catch (Exception e) {
                    String msg = "Failed to update observer {0} with {1} due to {2}";
                    msg = MessageFormat.format(msg, key, observer, e.getMessage());
                    logger.error(msg, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void registerObserver(String key, Observer observer) {
        List<Observer> observerList = this.observerMap.get(key);
        if (observerList == null) {
            observerList = new ArrayList<Observer>();
            this.observerMap.put(key, observerList);
        }
        observerList.add(observer);
        String msg = MessageFormat.format("Registered observer {0} with {1}", key, observer);
        logger.info(msg);
    }

    @Override
    public void unregisterObserver(String key, Observer observer) {
        List<Observer> observerList = this.observerMap.get(key);
        if (observerList != null && observerList.remove(observer)) {
            String msg = MessageFormat.format("Unregistered observer {0} with {1}", key, observer);
            logger.info(msg);
        }
    }
}

