/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.RealmHandler;
import li.strolch.agent.api.StrolchComponent;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.agent.impl.DataStoreMode;
import li.strolch.agent.impl.InternalStrolchRealm;
import li.strolch.exception.StrolchException;
import li.strolch.privilege.model.PrivilegeContext;
import li.strolch.runtime.StrolchConstants;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.runtime.privilege.PrivilegeHandler;
import li.strolch.utils.dbc.DBC;

public class DefaultRealmHandler
extends StrolchComponent
implements RealmHandler {
    public static final String PROP_ENABLE_AUDIT_TRAIL = "enableAuditTrail";
    public static final String PROP_ENABLE_AUDIT_TRAIL_FOR_READ = "enableAuditTrailForRead";
    public static final String PROP_ENABLE_OBSERVER_UPDATES = "enableObserverUpdates";
    public static final String PROP_ENABLE_VERSIONING = "enableVersioning";
    public static final String PREFIX_DATA_STORE_MODE = "dataStoreMode";
    public static final String PREFIX_DATA_STORE_FILE = "dataStoreFile";
    public static final String PROP_REALMS = "realms";
    protected Map<String, InternalStrolchRealm> realms;

    public DefaultRealmHandler(ComponentContainer container, String componentName) {
        super(container, componentName);
    }

    @Override
    public Set<String> getRealmNames() {
        return new HashSet<String>(this.realms.keySet());
    }

    @Override
    public StrolchRealm getRealm(String realm) throws StrolchException {
        DBC.PRE.assertNotEmpty("Realm name must be set!", realm);
        StrolchRealm strolchRealm = this.realms.get(realm);
        if (strolchRealm == null) {
            String msg = "No realm is configured with the name {0}";
            msg = MessageFormat.format(msg, realm);
            throw new StrolchException(msg);
        }
        return strolchRealm;
    }

    @Override
    public void setup(ComponentConfiguration configuration) {
        String[] realms;
        this.realms = new HashMap<String, InternalStrolchRealm>();
        for (String realmName : realms = configuration.getStringArray(PROP_REALMS, "defaultRealm")) {
            String dataStoreModeKey = StrolchConstants.makeRealmKey(realmName, PREFIX_DATA_STORE_MODE);
            String realmMode = configuration.getString(dataStoreModeKey, null);
            DataStoreMode dataStoreMode = DataStoreMode.parseDataStoreMode(realmMode);
            InternalStrolchRealm realm = dataStoreMode.createRealm(realmName);
            this.realms.put(realmName, realm);
        }
        super.setup(configuration);
    }

    @Override
    public void initialize(ComponentConfiguration configuration) throws Exception {
        for (String realmName : this.realms.keySet()) {
            InternalStrolchRealm realm = this.realms.get(realmName);
            realm.initialize(this.getContainer(), configuration);
        }
        super.initialize(configuration);
    }

    Map<String, InternalStrolchRealm> getRealms() {
        return this.realms;
    }

    @Override
    public void start() throws Exception {
        PrivilegeHandler privilegeHandler = this.getContainer().getComponent(PrivilegeHandler.class);
        privilegeHandler.runAsAgent((PrivilegeContext ctx) -> {
            for (String realmName : this.getRealms().keySet()) {
                InternalStrolchRealm realm = this.getRealms().get(realmName);
                realm.start(ctx);
            }
        });
        super.start();
    }

    @Override
    public void stop() throws Exception {
        for (String realmName : this.realms.keySet()) {
            InternalStrolchRealm realm = this.realms.get(realmName);
            realm.stop();
        }
        super.stop();
    }
}

