/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import li.strolch.agent.api.ActivityMap;
import li.strolch.agent.api.AuditTrail;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.OrderMap;
import li.strolch.agent.api.ResourceMap;
import li.strolch.agent.impl.DataStoreMode;
import li.strolch.agent.impl.InternalStrolchRealm;
import li.strolch.agent.impl.NoStrategyAuditTrail;
import li.strolch.agent.impl.TransactionalActivityMap;
import li.strolch.agent.impl.TransactionalAuditTrail;
import li.strolch.agent.impl.TransactionalOrderMap;
import li.strolch.agent.impl.TransactionalResourceMap;
import li.strolch.persistence.api.PersistenceHandler;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.persistence.inmemory.InMemoryPersistence;
import li.strolch.privilege.model.Certificate;
import li.strolch.privilege.model.PrivilegeContext;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.utils.dbc.DBC;

public class EmptyRealm
extends InternalStrolchRealm {
    private ResourceMap resourceMap;
    private OrderMap orderMap;
    private ActivityMap activityMap;
    private AuditTrail auditTrail;
    private PersistenceHandler persistenceHandler;

    public EmptyRealm(String realm) {
        super(realm);
    }

    @Override
    public DataStoreMode getMode() {
        return DataStoreMode.EMPTY;
    }

    @Override
    public StrolchTransaction openTx(Certificate certificate, String action) {
        DBC.PRE.assertNotNull("Certificate must be set!", (Object)certificate);
        return this.persistenceHandler.openTx(this, certificate, action);
    }

    @Override
    public StrolchTransaction openTx(Certificate certificate, Class<?> clazz) {
        DBC.PRE.assertNotNull("Certificate must be set!", (Object)certificate);
        return this.persistenceHandler.openTx(this, certificate, clazz.getName());
    }

    @Override
    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    @Override
    public OrderMap getOrderMap() {
        return this.orderMap;
    }

    @Override
    public ActivityMap getActivityMap() {
        return this.activityMap;
    }

    @Override
    public AuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    @Override
    public void initialize(ComponentContainer container, ComponentConfiguration configuration) {
        super.initialize(container, configuration);
        this.persistenceHandler = new InMemoryPersistence(container.getPrivilegeHandler(), this.isVersioningEnabled());
        this.resourceMap = new TransactionalResourceMap(this);
        this.orderMap = new TransactionalOrderMap(this);
        this.activityMap = new TransactionalActivityMap(this);
        this.auditTrail = this.isAuditTrailEnabled() ? new TransactionalAuditTrail() : new NoStrategyAuditTrail();
    }

    @Override
    public void start(PrivilegeContext privilegeContext) {
        logger.info(MessageFormat.format("Initialized EMPTY Realm {0}", this.getRealm()));
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }
}

