/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import li.strolch.agent.api.ActivityMap;
import li.strolch.agent.api.OrderMap;
import li.strolch.agent.api.ResourceMap;
import li.strolch.exception.StrolchException;
import li.strolch.model.Order;
import li.strolch.model.Resource;
import li.strolch.model.activity.Activity;
import li.strolch.model.xml.StrolchElementListener;
import li.strolch.persistence.api.StrolchTransaction;

public class InMemoryElementListener
implements StrolchElementListener {
    private boolean addOrders;
    private boolean addResources;
    private boolean addActivities;
    private boolean updateOrders;
    private boolean updateResources;
    private boolean updateActivities;
    private Set<String> orderTypes;
    private Set<String> resourceTypes;
    private Set<String> activityTypes;
    private boolean failOnUpdate;
    private StrolchTransaction tx;
    private ResourceMap resourceMap;
    private OrderMap orderMap;
    private ActivityMap activityMap;

    public InMemoryElementListener(StrolchTransaction tx) {
        this.tx = tx;
        this.resourceMap = tx.getResourceMap();
        this.orderMap = tx.getOrderMap();
        this.activityMap = tx.getActivityMap();
        this.addResources = true;
        this.addOrders = true;
        this.addActivities = true;
        this.updateResources = true;
        this.updateOrders = true;
        this.updateActivities = true;
        this.orderTypes = Collections.emptySet();
        this.resourceTypes = Collections.emptySet();
        this.activityTypes = Collections.emptySet();
    }

    public void setAddResources(boolean addResources) {
        this.addResources = addResources;
    }

    public void setAddOrders(boolean addOrders) {
        this.addOrders = addOrders;
    }

    public void setAddActivities(boolean addActivities) {
        this.addActivities = addActivities;
    }

    public void setUpdateResources(boolean updateResources) {
        this.updateResources = updateResources;
    }

    public void setUpdateOrders(boolean updateOrders) {
        this.updateOrders = updateOrders;
    }

    public void setUpdateActivities(boolean updateActivities) {
        this.updateActivities = updateActivities;
    }

    public void setOrderTypes(Set<String> orderTypes) {
        this.orderTypes = orderTypes;
    }

    public void setResourceTypes(Set<String> resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public void setActivityTypes(Set<String> activityTypes) {
        this.activityTypes = activityTypes;
    }

    public void setFailOnUpdate(boolean failOnUpdate) {
        this.failOnUpdate = failOnUpdate;
    }

    public void notifyResource(Resource resource) {
        if (!this.resourceTypes.isEmpty() && !this.resourceTypes.contains(resource.getType())) {
            return;
        }
        if (this.resourceMap.hasElement(this.tx, resource.getType(), resource.getId())) {
            if (this.updateResources) {
                this.resourceMap.update(this.tx, resource);
            } else if (this.failOnUpdate) {
                throw new StrolchException(MessageFormat.format("Resource {0} already exists and updating is disallowed!", resource.getLocator()));
            }
        } else if (this.addResources) {
            this.resourceMap.add(this.tx, resource);
        }
    }

    public void notifyOrder(Order order) {
        if (!this.orderTypes.isEmpty() && !this.orderTypes.contains(order.getType())) {
            return;
        }
        if (this.orderMap.hasElement(this.tx, order.getType(), order.getId())) {
            if (this.updateOrders) {
                this.orderMap.update(this.tx, order);
            } else if (this.failOnUpdate) {
                throw new StrolchException(MessageFormat.format("Order {0} already exists and updating is disallowed!", order.getLocator()));
            }
        } else if (this.addOrders) {
            this.orderMap.add(this.tx, order);
        }
    }

    public void notifyActivity(Activity activity) {
        if (!this.activityTypes.isEmpty() && !this.activityTypes.contains(activity.getType())) {
            return;
        }
        if (this.activityMap.hasElement(this.tx, activity.getType(), activity.getId())) {
            if (this.updateActivities) {
                this.activityMap.update(this.tx, activity);
            } else if (this.failOnUpdate) {
                throw new StrolchException(MessageFormat.format("Activity {0} already exists and updating is disallowed!", activity.getLocator()));
            }
        } else if (this.addActivities) {
            this.activityMap.add(this.tx, activity);
        }
    }
}

