/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import li.strolch.agent.api.ActivityMap;
import li.strolch.agent.api.AuditTrail;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.LockHandler;
import li.strolch.agent.api.ObserverHandler;
import li.strolch.agent.api.OrderMap;
import li.strolch.agent.api.ResourceMap;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.agent.impl.DefaultLockHandler;
import li.strolch.agent.impl.DefaultObserverHandler;
import li.strolch.model.StrolchRootElement;
import li.strolch.privilege.model.PrivilegeContext;
import li.strolch.runtime.StrolchConstants;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.utils.dbc.DBC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InternalStrolchRealm
implements StrolchRealm {
    public static final String PROP_TRY_LOCK_TIME_UNIT = "tryLockTimeUnit";
    public static final String PROP_TRY_LOCK_TIME = "tryLockTime";
    protected static final Logger logger = LoggerFactory.getLogger(StrolchRealm.class);
    private String realm;
    private LockHandler lockHandler;
    private boolean auditTrailEnabled;
    private boolean auditTrailEnabledForRead;
    private boolean versioningEnabled;
    private boolean updateObservers;
    private ObserverHandler observerHandler;

    public InternalStrolchRealm(String realm) {
        DBC.PRE.assertNotEmpty("RealmName may not be empty!", realm);
        this.realm = realm;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public void lock(StrolchRootElement element) {
        DBC.PRE.assertNotNull("Can not lock a null pointer =)", (Object)element);
        this.lockHandler.lock(element);
    }

    @Override
    public void unlock(StrolchRootElement lockedElement) {
        this.lockHandler.unlock(lockedElement);
    }

    @Override
    public void releaseLock(StrolchRootElement lockedElement) {
        this.lockHandler.releaseLock(lockedElement);
    }

    public void initialize(ComponentContainer container, ComponentConfiguration configuration) {
        logger.info("Initializing Realm " + this.getRealm() + "...");
        String enableAuditKey = StrolchConstants.makeRealmKey(this.getRealm(), "enableAuditTrail");
        this.auditTrailEnabled = configuration.getBoolean(enableAuditKey, Boolean.FALSE);
        String enableAuditForReadKey = StrolchConstants.makeRealmKey(this.getRealm(), "enableAuditTrailForRead");
        this.auditTrailEnabledForRead = configuration.getBoolean(enableAuditForReadKey, Boolean.FALSE);
        String updateObserversKey = StrolchConstants.makeRealmKey(this.getRealm(), "enableObserverUpdates");
        this.updateObservers = configuration.getBoolean(updateObserversKey, Boolean.FALSE);
        if (this.updateObservers) {
            this.observerHandler = new DefaultObserverHandler();
        }
        String propTryLockTimeUnit = StrolchConstants.makeRealmKey(this.realm, PROP_TRY_LOCK_TIME_UNIT);
        String propTryLockTime = StrolchConstants.makeRealmKey(this.realm, PROP_TRY_LOCK_TIME);
        TimeUnit timeUnit = TimeUnit.valueOf(configuration.getString(propTryLockTimeUnit, TimeUnit.SECONDS.name()));
        long time = configuration.getLong(propTryLockTime, 10L);
        this.lockHandler = new DefaultLockHandler(this.realm, timeUnit, time);
        String enableVersioningKey = StrolchConstants.makeRealmKey(this.getRealm(), "enableVersioning");
        this.versioningEnabled = configuration.getBoolean(enableVersioningKey, Boolean.FALSE);
        if (this.auditTrailEnabled) {
            logger.info("Enabling AuditTrail for realm " + this.getRealm());
        } else {
            logger.info("AuditTrail not enabled for realm " + this.getRealm());
        }
        if (this.auditTrailEnabledForRead) {
            logger.info("Enabling AuditTrail for read for realm " + this.getRealm());
        } else {
            logger.info("AuditTrail not enabled for read for realm " + this.getRealm());
        }
        if (this.updateObservers) {
            logger.info("Enabling Observer Updates for realm " + this.getRealm());
        } else {
            logger.info("Observer Updates not enabled for realm " + this.getRealm());
        }
        if (this.versioningEnabled) {
            logger.info("Enabling Versioning for realm " + this.getRealm());
        } else {
            logger.info("Versioning not enabled for realm " + this.getRealm());
        }
        logger.info(MessageFormat.format("Using a locking try timeout of {0}s", timeUnit.toSeconds(time)));
    }

    @Override
    public boolean isAuditTrailEnabled() {
        return this.auditTrailEnabled;
    }

    @Override
    public boolean isAuditTrailEnabledForRead() {
        return this.auditTrailEnabledForRead;
    }

    @Override
    public boolean isUpdateObservers() {
        return this.updateObservers;
    }

    @Override
    public boolean isVersioningEnabled() {
        return this.versioningEnabled;
    }

    @Override
    public ObserverHandler getObserverHandler() {
        if (!this.updateObservers) {
            throw new IllegalArgumentException("ObserverUpdates are not enabled!");
        }
        return this.observerHandler;
    }

    public abstract void start(PrivilegeContext var1);

    public abstract void stop();

    public abstract void destroy();

    public abstract ResourceMap getResourceMap();

    public abstract OrderMap getOrderMap();

    public abstract ActivityMap getActivityMap();

    public abstract AuditTrail getAuditTrail();
}

